/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.model.propertiesfile;

import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.model.propertiesfile.PropertiesKeyInstance;
import io.openliberty.tools.langserver.model.propertiesfile.PropertiesValueInstance;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;

public class PropertiesEntryInstance {
    private PropertiesKeyInstance propertyKeyInstance;
    private PropertiesValueInstance propertyValueInstance;
    private String line;
    private LibertyTextDocument textDocumentItem;
    private boolean isComment;

    public PropertiesEntryInstance(String entryLine, LibertyTextDocument textDocumentItem) {
        String propertyValueInstanceString;
        String propertyKeyInstanceString;
        this.line = entryLine;
        this.textDocumentItem = textDocumentItem;
        if (this.line.trim().startsWith("#")) {
            this.isComment = true;
            return;
        }
        this.isComment = false;
        int equalsIndex = this.line.indexOf("=");
        if (equalsIndex != -1) {
            propertyKeyInstanceString = this.line.substring(0, equalsIndex);
            propertyValueInstanceString = this.line.substring(equalsIndex + 1);
        } else {
            propertyKeyInstanceString = this.line;
            propertyValueInstanceString = null;
        }
        this.propertyKeyInstance = new PropertiesKeyInstance(propertyKeyInstanceString, this, textDocumentItem);
        this.propertyValueInstance = new PropertiesValueInstance(propertyValueInstanceString, this.propertyKeyInstance, textDocumentItem);
    }

    public String getKey() {
        return this.propertyKeyInstance.toString();
    }

    public String getValue() {
        return this.propertyValueInstance.toString();
    }

    public boolean isComment() {
        return this.isComment;
    }

    public String getLineContent() {
        return this.line;
    }

    public LibertyTextDocument getTextDocument() {
        return this.textDocumentItem;
    }

    private boolean isOnEntryKey(Position position) {
        return position.getCharacter() <= this.propertyKeyInstance.getEndPosition();
    }

    public CompletableFuture<Hover> getHover(Position position) {
        if (!this.isComment && this.isOnEntryKey(position)) {
            return this.propertyKeyInstance.getHover(position);
        }
        return CompletableFuture.completedFuture(new Hover(new MarkupContent("plaintext", "")));
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position) {
        if (!this.isComment) {
            if (this.propertyValueInstance.toString() != null && !this.isOnEntryKey(position)) {
                return this.propertyValueInstance.getCompletions(position);
            }
            return this.propertyKeyInstance.getCompletions(this.getKey(), position);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }
}

