/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.model.propertiesfile;

import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.model.propertiesfile.PropertiesEntryInstance;
import io.openliberty.tools.langserver.utils.Messages;
import io.openliberty.tools.langserver.utils.ServerPropertyValues;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class PropertiesKeyInstance {
    private String propertyKey;
    private PropertiesEntryInstance propertyEntryInstance;
    private LibertyTextDocument textDocumentItem;

    public PropertiesKeyInstance(String propertyKeyInstanceString, PropertiesEntryInstance propertyEntryInstance, LibertyTextDocument textDocumentItem) {
        this.propertyKey = propertyKeyInstanceString;
        this.propertyEntryInstance = propertyEntryInstance;
        this.textDocumentItem = textDocumentItem;
    }

    public int getEndPosition() {
        return this.propertyKey.length() - 1;
    }

    public CompletableFuture<Hover> getHover(Position position) {
        String message = null;
        message = Messages.getPropDescription(this.propertyKey);
        int line = position.getLine();
        Position rangeStart = new Position(line, 0);
        Position rangeEnd = new Position(line, this.propertyKey.length());
        Range range = new Range(rangeStart, rangeEnd);
        Hover hover = new Hover(new MarkupContent("markdown", message), range);
        return CompletableFuture.completedFuture(hover);
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(String enteredText, Position position) {
        List<String> matches = Messages.getMatchingKeys(enteredText, this.textDocumentItem);
        List<CompletionItem> results = matches.stream().map(s -> new CompletionItem(s)).collect(Collectors.toList());
        this.setDetailsOnCompletionItems(results, null, false);
        return CompletableFuture.completedFuture(results);
    }

    protected void setDetailsOnCompletionItems(List<CompletionItem> items, String key, boolean setDefault) {
        boolean defaultSet = false;
        for (CompletionItem item : items) {
            if (setDefault && !defaultSet) {
                item.setPreselect(Boolean.valueOf(true));
                defaultSet = true;
            }
            String keyToUse = key == null ? item.getLabel() : key;
            String desc = Messages.getPropDescription(keyToUse);
            MarkupContent markdown = new MarkupContent("markdown", desc);
            item.setDocumentation(markdown);
            if (setDefault) {
                item.setKind(CompletionItemKind.Text);
                continue;
            }
            item.setKind(CompletionItemKind.Property);
        }
    }

    public List<CompletionItem> getValidValues() {
        List<String> values = ServerPropertyValues.getValidValues(this.textDocumentItem, this.propertyKey);
        List<CompletionItem> results = values.stream().map(s -> new CompletionItem(s)).collect(Collectors.toList());
        this.setDetailsOnCompletionItems(results, this.propertyKey, true);
        return results;
    }

    public String toString() {
        return this.propertyKey;
    }
}

