/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.utils;

import java.util.HashMap;
import java.util.Set;

public class EquivalentProperties {
    private static HashMap<String, String> bootstrapToServerEnvMap = new HashMap<String, String>(){
        {
            this.put("com.ibm.ws.logging.json.field.mappings", "WLP_LOGGING_JSON_FIELD_MAPPINGS");
            this.put("com.ibm.ws.logging.log.directory", "LOG_DIR");
            this.put("com.ibm.ws.logging.console.format", "WLP_LOGGING_CONSOLE_FORMAT");
            this.put("com.ibm.ws.logging.console.log.level", "WLP_LOGGING_CONSOLE_LOGLEVEL");
            this.put("com.ibm.ws.logging.console.source", "WLP_LOGGING_CONSOLE_SOURCE");
            this.put("com.ibm.ws.logging.message.format", "WLP_LOGGING_MESSAGE_FORMAT");
            this.put("com.ibm.ws.logging.message.source", "WLP_LOGGING_MESSAGE_SOURCE");
            this.put("com.ibm.ws.logging.apps.write.json", "WLP_LOGGING_APPS_WRITE_JSON");
            this.put("com.ibm.ws.json.access.log.fields", "WLP_LOGGING_JSON_ACCESS_LOG_FIELDS");
        }
    };
    private static HashMap<String, String> serverEnvToBootstrapMap = new HashMap<String, String>(){
        {
            bootstrapToServerEnvMap.forEach((key, value) -> this.put(value, key));
        }
    };

    public static String getEquivalentProperty(String key) {
        String equivalentProperty = bootstrapToServerEnvMap.get(key);
        if (equivalentProperty == null) {
            equivalentProperty = serverEnvToBootstrapMap.get(key);
        }
        return equivalentProperty;
    }

    public static boolean hasEquivalentProperty(String key) {
        return bootstrapToServerEnvMap.containsKey(key) || serverEnvToBootstrapMap.containsKey(key);
    }

    public static Set<String> getBootstrapKeys() {
        return bootstrapToServerEnvMap.keySet();
    }

    public static Set<String> getServerVarKeys() {
        return serverEnvToBootstrapMap.keySet();
    }
}

