/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.utils;

import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.utils.EquivalentProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Messages {
    private static ResourceBundle serverenvMessages = null;
    private static ResourceBundle bootstrapMessages = null;
    private static List<String> serverPropertyKeys = null;
    private static List<String> bootstrapPropertyKeys = null;
    private static final Logger LOGGER = Logger.getLogger(Messages.class.getName());
    private static Pattern serverEnvKeyFormat = Pattern.compile("([A-Z]+)(_[A-Z]+)*");

    private static synchronized void initializeBundles() {
        Locale locale = Locale.getDefault();
        serverenvMessages = ResourceBundle.getBundle("ServerEnv", locale);
        bootstrapMessages = ResourceBundle.getBundle("BootstrapProperties", locale);
        serverPropertyKeys = Collections.list(serverenvMessages.getKeys());
        bootstrapPropertyKeys = Collections.list(bootstrapMessages.getKeys());
        bootstrapPropertyKeys.addAll(EquivalentProperties.getBootstrapKeys());
    }

    public static String getPropDescription(String key) {
        if (serverenvMessages == null) {
            Messages.initializeBundles();
        }
        String message = null;
        try {
            if (serverEnvKeyFormat.matcher(key).matches()) {
                message = serverenvMessages.getString(key);
            } else if (key.contains(".")) {
                message = EquivalentProperties.hasEquivalentProperty(key) ? serverenvMessages.getString(EquivalentProperties.getEquivalentProperty(key)) : bootstrapMessages.getString(key);
            }
        }
        catch (MissingResourceException e) {
            LOGGER.fine("No property description found for: " + key);
        }
        return message == null ? key : message;
    }

    public static List<String> getMatchingKeys(String query, LibertyTextDocument textDocument) {
        if (serverenvMessages == null) {
            Messages.initializeBundles();
        }
        String filename = textDocument.getUri();
        Predicate<String> filter = s -> {
            for (int i = s.length() - query.length(); i >= 0; --i) {
                if (!s.regionMatches(true, i, query, 0, query.length())) continue;
                return false;
            }
            return true;
        };
        if (filename.contains("server.env")) {
            ArrayList<String> keys = new ArrayList<String>(serverPropertyKeys);
            keys.removeIf(filter);
            return keys;
        }
        if (filename.contains("bootstrap.properties")) {
            ArrayList<String> keys = new ArrayList<String>(bootstrapPropertyKeys);
            keys.removeIf(filter);
            return keys;
        }
        return Collections.emptyList();
    }
}

