/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.utils;

import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.model.propertiesfile.PropertiesEntryInstance;
import io.openliberty.tools.langserver.utils.ParserFileHelperUtil;
import io.openliberty.tools.langserver.utils.ServerPropertyValues;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Range;

public class PropertiesValidationResult {
    Integer lineNumber;
    boolean hasErrors;
    String diagnosticType;
    PropertiesEntryInstance entry;
    LibertyTextDocument textDocumentItem;
    private static final Logger LOGGER = Logger.getLogger(PropertiesValidationResult.class.getName());

    public PropertiesValidationResult(PropertiesEntryInstance entry) {
        this.entry = entry;
        this.textDocumentItem = entry.getTextDocument();
        this.hasErrors = false;
    }

    public static PropertiesValidationResult validateServerProperty(String line, LibertyTextDocument textDocumentItem) {
        PropertiesEntryInstance entry = new PropertiesEntryInstance(line, textDocumentItem);
        PropertiesValidationResult result = new PropertiesValidationResult(entry);
        result.validateServerProperty();
        return result;
    }

    public void validateServerProperty() {
        if (this.entry.isComment()) {
            return;
        }
        String property = this.entry.getKey();
        String value = this.entry.getValue();
        if (ServerPropertyValues.usesPredefinedValues(this.textDocumentItem, property)) {
            List<String> validValues = ServerPropertyValues.getValidValues(this.textDocumentItem, property);
            this.hasErrors = ServerPropertyValues.isCaseSensitive(property) ? !validValues.contains(value) : !validValues.stream().anyMatch(value::equalsIgnoreCase);
            this.diagnosticType = ParserFileHelperUtil.isBootstrapPropertiesFile(this.textDocumentItem) ? "INVALID_PROPERTY_VALUE" : "INVALID_VARIABLE_VALUE";
        } else if (ServerPropertyValues.usesIntegerRangeValue(property)) {
            block16: {
                Range<Integer> range = ServerPropertyValues.getIntegerRange(property);
                if (ServerPropertyValues.usesTimeUnit(property)) {
                    try {
                        this.hasErrors = !range.contains((Object)Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        Pattern integerAndTime = Pattern.compile("(^[0-9]+)([h|H]?)$");
                        Matcher matcher = integerAndTime.matcher(value);
                        if (matcher.find()) {
                            try {
                                int val = new BigInteger(matcher.group(1)).intValueExact();
                                this.hasErrors = !range.contains((Object)val);
                            }
                            catch (ArithmeticException ae) {
                                this.hasErrors = true;
                            }
                            break block16;
                        }
                        this.hasErrors = true;
                    }
                } else {
                    try {
                        this.hasErrors = !range.contains((Object)Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        this.hasErrors = true;
                    }
                }
            }
            this.diagnosticType = ParserFileHelperUtil.isBootstrapPropertiesFile(this.textDocumentItem) ? "INVALID_PROPERTY_INTEGER_RANGE" : "INVALID_VARIABLE_INTEGER_RANGE";
        } else if (ServerPropertyValues.usesPackageNames(property)) {
            Pattern packageList = Pattern.compile("^([a-z_]+((\\.[a-z]|\\._[0-9])[a-z0-9_]*)*)(,[a-z_]+((\\.[a-z]|\\._[0-9])[a-z0-9_]*)*)*$");
            Matcher matcher = packageList.matcher(value);
            if (!matcher.find()) {
                this.hasErrors = true;
            }
            this.diagnosticType = "INVALID_PACKAGE_LIST_FORMAT";
        }
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public String getKey() {
        return this.entry.getKey();
    }

    public String getValue() {
        return this.entry.getValue();
    }

    public String getDiagnosticType() {
        return this.diagnosticType;
    }
}

