/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.utils;

import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.utils.EquivalentProperties;
import io.openliberty.tools.langserver.utils.ParserFileHelperUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Range;

public class ServerPropertyValues {
    public static final List<String> LOGGING_SOURCE_VALUES = Arrays.asList("message", "trace", "accessLog", "ffdc", "audit");
    public static final List<String> BOOLEAN_VALUES_DEFAULT_TRUE = Arrays.asList("true", "false");
    public static final List<String> BOOLEAN_VALUES_DEFAULT_FALSE = Arrays.asList("false", "true");
    public static final List<String> YES_NO_VALUES = Arrays.asList("y", "n");
    private static HashMap<String, List<String>> predefinedServerValues = new HashMap<String, List<String>>(){
        {
            this.put("WLP_DEBUG_SUSPEND", YES_NO_VALUES);
            this.put("WLP_DEBUG_REMOTE", YES_NO_VALUES);
            this.put("WLP_LOGGING_CONSOLE_FORMAT", Arrays.asList("DEV", "SIMPLE", "JSON", "TBASIC"));
            this.put("WLP_LOGGING_CONSOLE_LOGLEVEL", Arrays.asList("AUDIT", "INFO", "WARNING", "ERROR", "OFF"));
            this.put("WLP_LOGGING_CONSOLE_SOURCE", LOGGING_SOURCE_VALUES);
            this.put("WLP_LOGGING_MESSAGE_FORMAT", Arrays.asList("SIMPLE", "JSON", "TBASIC"));
            this.put("WLP_LOGGING_MESSAGE_SOURCE", LOGGING_SOURCE_VALUES);
            this.put("WLP_LOGGING_APPS_WRITE_JSON", BOOLEAN_VALUES_DEFAULT_FALSE);
        }
    };
    private static HashMap<String, List<String>> predefinedBootstrapValues = new HashMap<String, List<String>>(){
        {
            this.put("com.ibm.ws.logging.copy.system.streams", BOOLEAN_VALUES_DEFAULT_TRUE);
            this.put("com.ibm.ws.logging.newLogsOnStart", BOOLEAN_VALUES_DEFAULT_TRUE);
            this.put("com.ibm.ws.logging.isoDateFormat", BOOLEAN_VALUES_DEFAULT_FALSE);
            this.put("com.ibm.ws.logging.trace.format", Arrays.asList("ENHANCED", "BASIC", "TBASIC", "ADVANCED"));
            this.put("websphere.log.provider", Arrays.asList("binaryLogging-1.0"));
            this.put("com.ibm.hpel.log.bufferingEnabled", BOOLEAN_VALUES_DEFAULT_TRUE);
            this.put("com.ibm.hpel.trace.bufferingEnabled", BOOLEAN_VALUES_DEFAULT_TRUE);
            EquivalentProperties.getBootstrapKeys().forEach((? super T bskey) -> {
                String serverEnvEquivalent = EquivalentProperties.getEquivalentProperty(bskey);
                if (predefinedServerValues.containsKey(serverEnvEquivalent)) {
                    this.put(bskey, predefinedServerValues.get(serverEnvEquivalent));
                }
            });
        }
    };
    private static Set<String> caseSensitiveProperties = new HashSet<String>(){
        {
            this.add("WLP_DEBUG_SUSPEND");
            this.add("WLP_DEBUG_REMOTE");
            this.add("WLP_LOGGING_CONSOLE_SOURCE");
            this.add("WLP_LOGGING_MESSAGE_SOURCE");
            EquivalentProperties.getServerVarKeys().forEach(serverKey -> {
                if (this.contains(serverKey)) {
                    this.add(EquivalentProperties.getEquivalentProperty(serverKey));
                }
            });
        }
    };
    private static HashMap<String, Range<Integer>> integerRangeValues = new HashMap<String, Range<Integer>>(){
        {
            this.put("WLP_DEBUG_ADDRESS", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(65535)));
            this.put("default.http.port", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(65535)));
            this.put("default.https.port", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(65535)));
            this.put("command.port", Range.between((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(65535)));
            this.put("server.start.wait.time", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("osgi.console", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(65535)));
            this.put("com.ibm.ws.logging.max.files", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("com.ibm.ws.logging.max.file.size", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("com.ibm.hpel.log.purgeMaxSize", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("com.ibm.hpel.log.purgeMinTime", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("com.ibm.hpel.log.fileSwitchTime", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23)));
            this.put("com.ibm.hpel.trace.purgeMaxSize", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("com.ibm.hpel.trace.purgeMinTime", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.put("com.ibm.hpel.trace.fileSwitchTime", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23)));
        }
    };

    public static boolean usesPredefinedValues(LibertyTextDocument tdi, String key) {
        if (ParserFileHelperUtil.isBootstrapPropertiesFile(tdi)) {
            return predefinedBootstrapValues.containsKey(key);
        }
        if (ParserFileHelperUtil.isServerEnvFile(tdi)) {
            return predefinedServerValues.containsKey(key);
        }
        return false;
    }

    public static boolean usesIntegerRangeValue(String key) {
        return integerRangeValues.containsKey(key);
    }

    public static boolean usesTimeUnit(String key) {
        return key.endsWith("purgeMinTime");
    }

    public static boolean usesPackageNames(String key) {
        return key.equals("org.osgi.framework.bootdelegation");
    }

    public static List<String> getValidValues(LibertyTextDocument tdi, String key) {
        if (ParserFileHelperUtil.isBootstrapPropertiesFile(tdi)) {
            return predefinedBootstrapValues.getOrDefault(key, Collections.emptyList());
        }
        if (ParserFileHelperUtil.isServerEnvFile(tdi)) {
            return predefinedServerValues.getOrDefault(key, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public static boolean isCaseSensitive(String key) {
        return caseSensitiveProperties.contains(key);
    }

    public static Range<Integer> getIntegerRange(String key) {
        return integerRangeValues.get(key);
    }
}

