/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.PluginConfigSupport;
import java.io.IOException;
import java.util.List;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class RunServerMojo
extends PluginConfigSupport {
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(property="embedded", defaultValue="false")
    private boolean embedded;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping run goal.\n");
            return;
        }
        this.doRunServer();
    }

    private void doRunServer() throws MojoExecutionException {
        boolean hasDownstreamProjects;
        block29: {
            String projectPackaging = this.project.getPackaging();
            hasDownstreamProjects = false;
            ProjectDependencyGraph graph = this.session.getProjectDependencyGraph();
            if (graph != null) {
                List<MavenProject> relevantProjects = this.getRelevantMultiModuleProjects(graph);
                if (!relevantProjects.contains(this.project)) {
                    this.getLog().info((CharSequence)("\nSkipping module " + this.project.getArtifactId() + " which is not included in this invocation of the run goal.\n"));
                    return;
                }
                List downstreamProjects = graph.getDownstreamProjects(this.project, true);
                if (!downstreamProjects.isEmpty()) {
                    this.getLog().debug((CharSequence)("Downstream projects: " + downstreamProjects));
                    hasDownstreamProjects = true;
                }
                if (this.containsPreviousLibertyModule(graph)) {
                    return;
                }
            }
            if (projectPackaging.equals("ear")) {
                this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "generate-application-xml");
                this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                if (hasDownstreamProjects && this.looseApplication) {
                    this.getOrCreateEarArtifact(this.project);
                }
            } else if (projectPackaging.equals("pom")) {
                this.getLog().debug((CharSequence)"Skipping compile/resources on module with pom packaging type");
            } else {
                this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                this.runMojo("org.apache.maven.plugins", "maven-compiler-plugin", "compile");
                this.updateArtifactPathToOutputDirectory(this.project);
            }
            if (!this.looseApplication) {
                try {
                    switch (projectPackaging) {
                        case "war": {
                            this.runMojo("org.apache.maven.plugins", "maven-war-plugin", "war");
                            break;
                        }
                        case "ear": {
                            this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "ear");
                            break;
                        }
                        case "ejb": {
                            this.runMojo("org.apache.maven.plugins", "maven-ejb-plugin", "ejb");
                            break;
                        }
                        case "bundle": {
                            this.runMojo("org.apache.felix", "maven-bundle-plugin", "bundle");
                            break;
                        }
                        case "jar": {
                            this.runMojo("org.apache.maven.plugins", "maven-jar-plugin", "jar");
                        }
                    }
                }
                catch (MojoExecutionException e) {
                    if (graph == null || graph.getUpstreamProjects(this.project, true).isEmpty()) break block29;
                    this.getLog().warn((CharSequence)("The looseApplication parameter was set to false for the module with artifactId " + this.project.getArtifactId() + ". Ensure that all modules use the same value for the looseApplication parameter by including -DlooseApplication=false in the Maven command for your multi module project."));
                    throw e;
                }
            }
        }
        if (hasDownstreamProjects) {
            return;
        }
        this.runLibertyMojoCreate();
        this.runLibertyMojoInstallFeature(null, null, null);
        this.runLibertyMojoDeploy(false);
        ServerTask serverTask = this.initializeJava();
        try {
            this.copyConfigFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying configuration files to Liberty server directory.", (Exception)e);
        }
        serverTask.setUseEmbeddedServer(this.embedded);
        serverTask.setClean(this.clean);
        serverTask.setOperation("run");
        serverTask.execute();
    }
}

