/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.ant.InstallFeatureTask;
import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.maven.InstallFeatureSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-feature", threadSafe=true)
public class InstallFeatureMojo
extends InstallFeatureSupport {
    @Parameter
    private String containerName;
    @Parameter
    private File serverDir;

    public void execute() throws MojoExecutionException {
        this.init();
        if (!this.initialize()) {
            return;
        }
        this.doInstallFeatures();
    }

    private void doInstallFeatures() throws MojoExecutionException {
        if (this.serverDir != null) {
            this.serverDirectory = this.serverDir;
            this.getLog().debug((CharSequence)("Overriding the server directory with: " + this.serverDirectory));
        }
        try {
            this.installFeatures();
        }
        catch (PluginExecutionException e) {
            throw new MojoExecutionException("Error installing features for server " + this.serverName, (Exception)((Object)e));
        }
    }

    private void installFeatures() throws PluginExecutionException {
        List propertiesList = null;
        String openLibertyVersion = null;
        boolean isClosedLiberty = false;
        if (this.containerName == null) {
            propertiesList = InstallFeatureUtil.loadProperties((File)this.installDirectory);
            openLibertyVersion = InstallFeatureUtil.getOpenLibertyVersion((List)propertiesList);
            isClosedLiberty = InstallFeatureUtil.isClosedLiberty((List)propertiesList);
            boolean skipBetaInstallFeatureWarning = Boolean.parseBoolean(System.getProperty("skipBetaInstallFeatureWarning"));
            if (InstallFeatureUtil.isOpenLibertyBetaVersion((String)openLibertyVersion)) {
                if (!skipBetaInstallFeatureWarning) {
                    this.getLog().warn((CharSequence)"Features that are not included with the beta runtime cannot be installed. Features that are included with the beta runtime can be enabled by adding them to your server.xml file.");
                }
                return;
            }
        }
        Set<String> pluginListedEsas = this.getPluginListedFeatures(true);
        List<String> additionalJsons = this.getAdditionalJsonList();
        Collection<Map<String, String>> keyMap = this.getKeyMap();
        this.util = this.getInstallFeatureUtil(pluginListedEsas, propertiesList, openLibertyVersion, this.containerName, additionalJsons, keyMap);
        Set<String> featuresToInstall = this.getSpecifiedFeatures(this.containerName);
        if (!pluginListedEsas.isEmpty() && isClosedLiberty) {
            this.installFromAnt = true;
        }
        if (this.installFromAnt) {
            this.installFeaturesFromAnt(this.features.getFeatures());
        } else if (this.util != null) {
            this.util.installFeatures(this.features.isAcceptLicense(), new ArrayList<String>(featuresToInstall));
        }
    }

    private void installFeaturesFromAnt(List<FeatureManagerTask.Feature> installFeatures) {
        InstallFeatureTask installFeatureTask;
        if (this.defaultOutputDirSet) {
            this.outputDirectory = new File(this.project.getBuild().getDirectory(), "liberty-alt-output-dir");
        }
        if ((installFeatureTask = (InstallFeatureTask)this.ant.createTask("antlib:io/openliberty/tools/ant:install-feature")) == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "install-feature"));
        }
        installFeatureTask.setInstallDir(this.installDirectory);
        installFeatureTask.setServerName(this.serverName);
        installFeatureTask.setUserDir(this.userDirectory);
        installFeatureTask.setOutputDir(this.outputDirectory);
        installFeatureTask.setAcceptLicense(this.features.isAcceptLicense());
        installFeatureTask.setTo(this.features.getTo());
        installFeatureTask.setWhenFileExists(this.features.getWhenFileExists());
        installFeatureTask.setFeatures(installFeatures);
        installFeatureTask.setFrom(this.features.getFrom());
        installFeatureTask.execute();
    }
}

