/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.ant.install.InstallLibertyTask;
import io.openliberty.tools.common.plugins.util.AbstractContainerSupportUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.maven.AbstractLibertySupport;
import io.openliberty.tools.maven.Install;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class BasicSupport
extends AbstractLibertySupport {
    protected static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    protected static final ResourceBundle messages = ResourceBundle.getBundle("io.openliberty.tools.maven.MvnMessages");
    protected boolean defaultOutputDirSet = false;
    protected boolean skipServerConfigSetup = false;
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip = false;
    @Parameter(property="refresh", defaultValue="false")
    protected boolean refresh = false;
    @Parameter(property="isInstall", defaultValue="true")
    protected boolean isInstall = true;
    @Parameter(alias="runtimeInstallDirectory", property="runtimeInstallDirectory", defaultValue="${project.build.directory}/liberty")
    protected File assemblyInstallDirectory;
    @Parameter(property="installDirectory")
    protected File installDirectory;
    @Parameter(property="serverName", defaultValue="defaultServer")
    protected String serverName = null;
    @Parameter(alias="configFile", property="serverXmlFile")
    protected File serverXmlFile;
    @Parameter(property="userDirectory")
    protected File userDirectory = null;
    protected boolean userDirectorySpecified = false;
    @Parameter(property="outputDirectory")
    protected File outputDirectory = null;
    @Parameter(property="useOpenLiberty")
    private boolean useOpenLiberty = true;
    protected File serverDirectory;
    protected InstallType installType;
    @Parameter(alias="runtimeArchive", property="runtimeArchive")
    protected File assemblyArchive;
    @Parameter(alias="runtimeArtifact", property="runtimeArtifact")
    protected Dependency assemblyArtifact;
    @Parameter
    protected Install install;
    @Parameter
    protected Dependency licenseArtifact;
    @Parameter(property="configDirectory", defaultValue="${basedir}/src/main/liberty/config")
    protected File configDirectory;
    @Parameter(alias="serverEnv", property="serverEnvFile")
    protected File serverEnvFile;
    @Parameter(property="mergeServerEnv", defaultValue="false")
    protected boolean mergeServerEnv;
    @Parameter(alias="libertyRuntimeGroupId", property="liberty.runtime.groupId")
    protected String libertyRuntimeGroupId = null;
    @Parameter(alias="libertyRuntimeArtifactId", property="liberty.runtime.artifactId")
    protected String libertyRuntimeArtifactId = null;
    @Parameter(alias="libertyRuntimeVersion", property="liberty.runtime.version")
    protected String libertyRuntimeVersion = null;
    private InitLog initLog = new InitLog();

    @Override
    protected void init() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        super.init();
        if (this.skipServerConfigSetup) {
            return;
        }
        try {
            if (this.installDirectory != null) {
                this.installDirectory = this.installDirectory.getCanonicalFile();
                File file = new File(this.installDirectory, "lib/ws-launch.jar");
                if (!file.exists()) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.install.dir.validate"), ""));
                }
                this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "pre-installed assembly", this.installDirectory));
                this.installType = InstallType.ALREADY_EXISTS;
            } else if (this.assemblyArchive != null) {
                this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based assembly archive", this.assemblyArchive));
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            } else if (this.install != null) {
                this.installType = InstallType.FROM_ARCHIVE;
                this.installDirectory = new File(this.assemblyInstallDirectory, "wlp");
                this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            } else {
                Artifact artifact;
                this.assemblyArtifact.setType("zip");
                if (this.libertyRuntimeGroupId != null && !this.libertyRuntimeGroupId.isEmpty()) {
                    if (this.assemblyArtifact.getGroupId() != null) {
                        this.initLog.info("The runtimeArtifact groupId " + this.assemblyArtifact.getGroupId() + " is overwritten by the liberty.runtime.groupId value " + this.libertyRuntimeGroupId + ".");
                    } else {
                        this.initLog.info("The liberty.runtime.groupId property value " + this.libertyRuntimeGroupId + " is used for the runtimeArtifact groupId.");
                    }
                    this.assemblyArtifact.setGroupId(this.libertyRuntimeGroupId);
                } else if (this.assemblyArtifact.getGroupId() == null) {
                    this.initLog.debug("Defaulting runtimeArtifact group id to 'io.openliberty'");
                    this.assemblyArtifact.setGroupId("io.openliberty");
                }
                if (this.libertyRuntimeArtifactId != null && !this.libertyRuntimeArtifactId.isEmpty()) {
                    if (this.assemblyArtifact.getArtifactId() != null) {
                        this.initLog.info("The runtimeArtifact artifactId " + this.assemblyArtifact.getArtifactId() + " is overwritten by the liberty.runtime.artifactId value " + this.libertyRuntimeArtifactId + ".");
                    } else {
                        this.initLog.info("The liberty.runtime.artifactId property value " + this.libertyRuntimeArtifactId + " is used for the runtimeArtifact artifactId.");
                    }
                    this.assemblyArtifact.setArtifactId(this.libertyRuntimeArtifactId);
                } else if (this.assemblyArtifact.getArtifactId() == null) {
                    this.initLog.debug("Defaulting runtimeArtifact artifact id to 'openliberty-kernel'");
                    this.assemblyArtifact.setArtifactId("openliberty-kernel");
                }
                if (this.libertyRuntimeVersion != null && !this.libertyRuntimeVersion.isEmpty()) {
                    if (this.assemblyArtifact.getVersion() != null) {
                        this.initLog.info("The runtimeArtifact version " + this.assemblyArtifact.getVersion() + " is overwritten by the liberty.runtime.version value " + this.libertyRuntimeVersion + ".");
                    } else {
                        this.initLog.info("The liberty.runtime.version property value " + this.libertyRuntimeVersion + " is used for the runtimeArtifact version.");
                    }
                    this.assemblyArtifact.setVersion(this.libertyRuntimeVersion);
                }
                if ((artifact = this.getResolvedArtifact(this.assemblyArtifact)) == null) {
                    this.initLog.debug("Defaulting runtimeArtifact version to '[22.0.0.3,)'");
                    this.assemblyArtifact.setVersion("[22.0.0.3,)");
                    artifact = this.createArtifact(this.assemblyArtifact);
                }
                this.assemblyArchive = artifact.getFile();
                if (this.assemblyArchive == null) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.assembly.validate"), "artifact based assembly archive", ""));
                }
                this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "artifact based assembly archive", this.getArtifactString(this.assemblyArtifact)));
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            }
            if (this.serverName == null) {
                this.serverName = "defaultServer";
            }
            this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "serverName", this.serverName));
            if (this.userDirectory == null) {
                this.userDirectory = new File(this.installDirectory, "usr");
            } else {
                this.userDirectorySpecified = true;
            }
            File serversDirectory = new File(this.userDirectory, "servers");
            this.serverDirectory = new File(serversDirectory, this.serverName);
            this.initLog.info(MessageFormat.format(messages.getString("info.variable.set"), "serverDirectory", this.serverDirectory));
            if (this.getWlpOutputDir() != null) {
                this.outputDirectory = new File(this.getWlpOutputDir());
            } else if (this.outputDirectory == null) {
                this.outputDirectory = serversDirectory;
                this.defaultOutputDirSet = true;
            }
        }
        catch (Throwable t) {
            this.initLog.flush();
            throw new MojoExecutionException(t.getMessage(), t);
        }
    }

    protected String getArtifactString(Dependency artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append(":");
        sb.append(artifact.getArtifactId());
        sb.append(":");
        sb.append(artifact.getClassifier());
        sb.append(":");
        sb.append(artifact.getVersion());
        sb.append(":");
        sb.append(artifact.getType());
        return sb.toString();
    }

    protected void checkServerHomeExists() throws MojoExecutionException {
        if (!this.installDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.home.noexist"), this.installDirectory));
        }
    }

    protected void checkServerDirectoryExists() throws MojoExecutionException {
        if (!this.serverDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.noexist"), this.serverName));
        }
    }

    private File checkServerHome(File archive) throws IOException, MojoExecutionException {
        this.initLog.debug(MessageFormat.format(messages.getString("debug.discover.server.home"), ""));
        File dir = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> n = zipFile.entries();
            while (n.hasMoreElements()) {
                ZipEntry entry = n.nextElement();
                if (!entry.getName().endsWith("lib/ws-launch.jar")) continue;
                File file = new File(this.assemblyInstallDirectory, entry.getName());
                dir = file.getParentFile().getParentFile();
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.discover.server.home.fail"), archive), (Exception)e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        if (dir == null) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.archive.not.contain.server"), archive));
        }
        return dir.getCanonicalFile();
    }

    protected void installServerAssembly() throws MojoExecutionException, IOException {
        this.initLog.flush();
        if (this.installType == InstallType.ALREADY_EXISTS) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
        } else {
            if (this.installType == InstallType.FROM_ARCHIVE) {
                this.installFromArchive();
            } else {
                this.installFromFile();
            }
            this.installLicense();
        }
    }

    protected void installFromFile() throws MojoExecutionException, IOException {
        File installMarker = new File(this.installDirectory, ".installed");
        if (!this.refresh) {
            if (!installMarker.exists()) {
                this.refresh = true;
            } else if (this.assemblyArchive.lastModified() > installMarker.lastModified()) {
                this.getLog().debug((CharSequence)MessageFormat.format(messages.getString("debug.detect.assembly.archive"), ""));
                this.refresh = true;
            } else if (!this.assemblyArchive.getCanonicalPath().equals(FileUtils.fileRead((File)installMarker))) {
                this.refresh = true;
            }
        } else {
            this.getLog().debug((CharSequence)MessageFormat.format(messages.getString("debug.request.refresh"), ""));
        }
        String userDirectoryPath = this.userDirectory.getCanonicalPath();
        if (this.refresh && this.installDirectory.exists() && this.installDirectory.isDirectory()) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.uninstalling.server.home"), this.installDirectory));
            for (File f : this.installDirectory.listFiles()) {
                if (f.isDirectory() && f.getCanonicalPath().equals(userDirectoryPath)) continue;
                FileUtils.forceDelete((File)f);
            }
        }
        if (!installMarker.exists()) {
            this.getLog().info((CharSequence)"Installing assembly...");
            FileUtils.forceMkdir((File)this.installDirectory);
            Expand unzip = (Expand)this.ant.createTask("unzip");
            unzip.setSrc(this.assemblyArchive);
            unzip.setDest(this.assemblyInstallDirectory.getCanonicalFile());
            unzip.execute();
            Chmod chmod = (Chmod)this.ant.createTask("chmod");
            chmod.setPerm("ugo+rx");
            chmod.setDir(this.installDirectory);
            chmod.setIncludes("bin/*");
            chmod.setExcludes("bin/*.bat");
            chmod.execute();
            installMarker.delete();
            installMarker.createNewFile();
            FileUtils.fileWrite((File)installMarker, (String)this.assemblyArchive.getCanonicalPath());
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.reuse.installed.assembly"), ""));
        }
    }

    protected void installFromArchive() throws MojoExecutionException, IOException {
        InstallLibertyTask installTask = (InstallLibertyTask)this.ant.createTask("antlib:io/openliberty/tools/ant:install-liberty");
        if (installTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "install-liberty"));
        }
        installTask.setBaseDir(this.assemblyInstallDirectory.getAbsolutePath());
        installTask.setLicenseCode(this.install.getLicenseCode());
        installTask.setVersion(this.install.getVersion());
        installTask.setRuntimeUrl(this.install.getRuntimeUrl());
        installTask.setVerbose(this.install.isVerbose());
        installTask.setMaxDownloadTime(this.install.getMaxDownloadTime());
        installTask.setType(this.install.getType());
        installTask.setOffline(this.settings.isOffline());
        installTask.setUseOpenLiberty(this.useOpenLiberty);
        String cacheDir = this.install.getCacheDirectory();
        if (cacheDir == null) {
            File dir = new File(this.getRepoSession().getLocalRepository().getBasedir(), "wlp-cache");
            installTask.setCacheDir(dir.getAbsolutePath());
        } else {
            installTask.setCacheDir(cacheDir);
        }
        String serverId = this.install.getServerId();
        if (serverId != null) {
            Server server = this.settings.getServer(serverId);
            if (server == null) {
                throw new MojoExecutionException("Server id not found: " + serverId);
            }
            installTask.setUsername(server.getUsername());
            installTask.setPassword(server.getPassword());
        } else {
            installTask.setUsername(this.install.getUsername());
            installTask.setPassword(this.install.getPassword());
        }
        installTask.execute();
    }

    protected String stripVersionFromName(String name, String version) {
        int versionBeginIndex = name.lastIndexOf("-" + version);
        if (versionBeginIndex != -1) {
            return name.substring(0, versionBeginIndex) + name.substring(versionBeginIndex + version.length() + 1);
        }
        return name;
    }

    protected void installLicense() throws MojoExecutionException, IOException {
        Artifact license;
        if (this.licenseArtifact != null && !this.hasSameLicense(license = this.getArtifact(this.licenseArtifact))) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.license"), this.licenseArtifact.getGroupId() + ":" + this.licenseArtifact.getArtifactId() + ":" + this.licenseArtifact.getVersion()));
            Java installLicenseTask = (Java)this.ant.createTask("java");
            installLicenseTask.setJar(license.getFile());
            Commandline.Argument args = installLicenseTask.createArg();
            args.setLine("--acceptLicense " + this.assemblyInstallDirectory.getCanonicalPath());
            installLicenseTask.setTimeout(Long.valueOf(30000L));
            installLicenseTask.setFork(true);
            int rc = installLicenseTask.executeJava();
            if (rc != 0) {
                throw new MojoExecutionException(MessageFormat.format(messages.getString("error.install.license"), this.licenseArtifact.getGroupId() + ":" + this.licenseArtifact.getArtifactId() + ":" + this.licenseArtifact.getVersion(), rc));
            }
        }
    }

    protected void deleteApplication(File serverDirectory, File artifactFile, File destFile) throws IOException {
        String artifactFileName;
        String destFileName = destFile.getName();
        boolean namesAreDifferent = !destFileName.equals(artifactFileName = artifactFile.getName());
        this.deleteApplication(new File(serverDirectory, "apps"), artifactFile);
        this.deleteApplication(new File(serverDirectory, "dropins"), artifactFile);
        this.deleteApplication(new File(serverDirectory, "apps/expanded"), artifactFile);
        if (namesAreDifferent) {
            this.deleteApplication(new File(serverDirectory, "apps"), destFile);
            this.deleteApplication(new File(serverDirectory, "dropins"), destFile);
            this.deleteApplication(new File(serverDirectory, "apps/expanded"), destFile);
        }
    }

    protected void deleteApplication(File parent, File artifactFile) throws IOException {
        this.deleteApplication(parent, artifactFile.getName());
        if (artifactFile.getName().endsWith(".xml")) {
            this.deleteApplication(parent, artifactFile.getName().substring(0, artifactFile.getName().length() - 4));
        } else {
            this.deleteApplication(parent, artifactFile.getName() + ".xml");
        }
    }

    protected void deleteApplication(File parent, String filename) throws IOException {
        File application = new File(parent, filename);
        if (application.isDirectory()) {
            FileUtils.deleteDirectory((File)application);
        } else if (application.exists()) {
            application.delete();
        }
    }

    private boolean hasSameLicense(Artifact license) throws MojoExecutionException, IOException {
        boolean sameLicense = false;
        if (license != null) {
            InputStream licenseInfo = this.getZipEntry(license.getFile(), "wlp/lafiles/LI_en");
            if (licenseInfo == null) {
                this.getLog().warn((CharSequence)MessageFormat.format(messages.getString("warn.install.license"), license.getId()));
                return sameLicense;
            }
            File lic = new File(this.assemblyInstallDirectory, "wlp/lafiles/LI_en");
            if (lic.exists()) {
                FileInputStream installedLicenseInfo = new FileInputStream(lic);
                sameLicense = IOUtil.contentEquals((InputStream)licenseInfo, (InputStream)installedLicenseInfo);
                licenseInfo.close();
                installedLicenseInfo.close();
            }
        }
        return sameLicense;
    }

    private InputStream getZipEntry(File zip, String entry) throws IOException {
        ZipEntry e;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zip));
        while ((e = zipInputStream.getNextEntry()) != null) {
            if (!e.getName().equals(entry)) continue;
            return zipInputStream;
        }
        return null;
    }

    private String getWlpOutputDir() throws IOException {
        Properties envvars = new Properties();
        File serverEnvInstallDir = new File(this.installDirectory, "etc/server.env");
        if (serverEnvInstallDir.exists()) {
            envvars.load(new FileInputStream(serverEnvInstallDir));
        }
        if (this.serverEnvFile != null && this.serverEnvFile.exists()) {
            envvars.load(new FileInputStream(this.serverEnvFile));
        } else {
            File serverEnvFileConfigDir = new File(this.configDirectory, "server.env");
            if (serverEnvFileConfigDir.exists()) {
                envvars.load(new FileInputStream(serverEnvFileConfigDir));
            }
        }
        return (String)envvars.get("WLP_OUTPUT_DIR");
    }

    public static Map<String, File> getLibertyDirectoryPropertyFiles(File installDir, File userDir, File serverDir) throws IOException {
        HashMap<String, File> libertyDirectoryPropertyToFile = new HashMap<String, File>();
        if (serverDir.exists()) {
            libertyDirectoryPropertyToFile.put("server.config.dir", serverDir.getCanonicalFile());
            libertyDirectoryPropertyToFile.put("wlp.install.dir", installDir.getCanonicalFile());
            libertyDirectoryPropertyToFile.put("wlp.user.dir", userDir.getCanonicalFile());
            File userExtDir = new File(userDir, "extension");
            libertyDirectoryPropertyToFile.put("usr.extension.dir", userExtDir.getCanonicalFile());
            File userSharedDir = new File(userDir, "shared");
            File userSharedAppDir = new File(userSharedDir, "app");
            File userSharedConfigDir = new File(userSharedDir, "config");
            File userSharedResourcesDir = new File(userSharedDir, "resources");
            File userSharedStackGroupsDir = new File(userSharedDir, "stackGroups");
            libertyDirectoryPropertyToFile.put("shared.app.dir", userSharedAppDir.getCanonicalFile());
            libertyDirectoryPropertyToFile.put("shared.config.dir", userSharedConfigDir.getCanonicalFile());
            libertyDirectoryPropertyToFile.put("shared.resource.dir", userSharedResourcesDir.getCanonicalFile());
            libertyDirectoryPropertyToFile.put("shared.stackgroup.dir", userSharedStackGroupsDir.getCanonicalFile());
        }
        return libertyDirectoryPropertyToFile;
    }

    protected Map<String, File> getLibertyDirectoryPropertyFiles() {
        if (this.serverDirectory.exists()) {
            try {
                return BasicSupport.getLibertyDirectoryPropertyFiles(this.installDirectory, this.userDirectory, this.serverDirectory);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"The properties for directories could not be initialized because an error occurred when accessing the directories.");
                this.getLog().debug((CharSequence)("Exception received: " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.getLog().warn((CharSequence)("The " + this.serverDirectory + " directory cannot be accessed. The properties for directories could not be initialized."));
        }
        return new HashMap<String, File>();
    }

    protected void setContainerEngine(AbstractContainerSupportUtil util) throws PluginExecutionException {
        String LIBERTY_DEV_PODMAN = "liberty.dev.podman";
        Object podmanPropValue = null;
        if (System.getProperties().containsKey(LIBERTY_DEV_PODMAN)) {
            podmanPropValue = System.getProperties().get(LIBERTY_DEV_PODMAN);
        } else if (this.project.getProperties().containsKey(LIBERTY_DEV_PODMAN)) {
            podmanPropValue = this.project.getProperties().get(LIBERTY_DEV_PODMAN);
        }
        if (podmanPropValue != null) {
            util.setIsDocker(!Boolean.parseBoolean(podmanPropValue.toString()));
            this.getLog().debug((CharSequence)("liberty.dev.podman was set to: " + Boolean.parseBoolean(podmanPropValue.toString())));
        }
    }

    private class InitLog {
        private List<MessageType> msgTypes = new ArrayList<MessageType>();
        private List<String> messages = new ArrayList<String>();

        private InitLog() {
        }

        public void flush() {
            for (int i = 0; i < this.msgTypes.size(); ++i) {
                if (this.msgTypes.get(i) == MessageType.INFO) {
                    BasicSupport.this.getLog().info((CharSequence)this.messages.get(i));
                    continue;
                }
                BasicSupport.this.getLog().debug((CharSequence)this.messages.get(i));
            }
            this.msgTypes.clear();
            this.messages.clear();
        }

        public void info(String msg) {
            this.messages.add(msg);
            this.msgTypes.add(MessageType.INFO);
        }

        public void debug(String msg) {
            this.messages.add(msg);
            this.msgTypes.add(MessageType.DEBUG);
        }
    }

    private static enum MessageType {
        INFO,
        DEBUG;

    }

    protected static enum InstallType {
        FROM_FILE,
        ALREADY_EXISTS,
        FROM_ARCHIVE;

    }
}

