/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.applications;

import io.openliberty.tools.common.plugins.config.ApplicationXmlDocument;
import io.openliberty.tools.common.plugins.config.LooseConfigData;
import io.openliberty.tools.maven.applications.DeployMojoSupport;
import io.openliberty.tools.maven.utils.CommonLogger;
import io.openliberty.tools.maven.utils.SpringBootUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class DeployMojo
extends DeployMojoSupport {
    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping deploy goal.\n");
            return;
        }
        try {
            this.doDeploy();
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("Error deploying application.", e);
        }
    }

    private void doDeploy() throws IOException, MojoExecutionException, TransformerException, ParserConfigurationException {
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        this.cleanupPreviousExecution();
        this.copyConfigFiles();
        boolean installDependencies = false;
        boolean installProject = false;
        switch (this.getDeployPackages()) {
            case "all": {
                installDependencies = true;
                installProject = true;
                break;
            }
            case "dependencies": {
                installDependencies = true;
                break;
            }
            case "project": {
                installProject = true;
                break;
            }
            case "spring-boot-project": {
                this.installSpringBootApp();
                break;
            }
            default: {
                return;
            }
        }
        if (installDependencies) {
            this.installDependencies();
        }
        if (installProject) {
            this.installProject();
        }
        if (this.applicationXml.hasChildElements()) {
            this.getLog().warn((CharSequence)messages.getString("warn.install.app.add.configuration"));
            this.applicationXml.writeApplicationXmlDocument(this.serverDirectory);
        }
    }

    private void installSpringBootApp() throws MojoExecutionException, IOException {
        if (!SpringBootUtil.doesSpringBootRepackageGoalExecutionExist(this.project)) {
            throw new MojoExecutionException("The repackage goal of the spring-boot-maven-plugin must be configured to run first in order to create the required executable archive.");
        }
        File fatArchiveSrc = SpringBootUtil.getSpringBootUberJAR(this.project, this.getLog());
        File serverXML = new File(this.serverDirectory, "server.xml");
        CommonLogger logger = new CommonLogger(this.getLog());
        this.setLog(logger.getLog());
        this.getServerConfigDocument(logger, serverXML);
        if (!io.openliberty.tools.common.plugins.util.SpringBootUtil.isSpringBootUberJar((File)fatArchiveSrc)) {
            File fatArchive = SpringBootUtil.getSpringBootUberJARLocation(this.project, this.getLog());
            throw new MojoExecutionException(fatArchive.getCanonicalPath() + " file is not an executable archive. The repackage goal of the spring-boot-maven-plugin must be configured to run first in order to create the required executable archive.");
        }
        File thinArchiveTarget = this.getThinArchiveTarget(fatArchiveSrc);
        File libIndexCacheTarget = this.getLibIndexCacheTarget();
        this.validateAppConfig(thinArchiveTarget.getCanonicalPath(), thinArchiveTarget.getName(), this.project.getArtifactId(), true);
        this.installSpringBootFeatureIfNeeded(this.installDirectory);
        this.invokeSpringBootUtilCommand(this.installDirectory, fatArchiveSrc.getCanonicalPath(), thinArchiveTarget.getCanonicalPath(), libIndexCacheTarget.getCanonicalPath());
    }

    private File getThinArchiveTarget(File archiveSrc) {
        String appsDirName = this.getAppsDirectory();
        File archiveTarget = null;
        File appsDir = null;
        File rootDirectory = this.serverDirectory;
        if (this.project.getProperties().containsKey("container")) {
            rootDirectory = new File(this.project.getBuild().getDirectory(), ".libertyDevc");
        }
        if ("apps".equals(appsDirName)) {
            appsDir = new File(rootDirectory, appsDirName);
        } else if ("dropins".equals(appsDirName)) {
            appsDir = new File(rootDirectory, appsDirName + "/spring");
        }
        archiveTarget = this.scd != null && this.scd.getSpringBootAppNodeLocation().isPresent() ? new File(appsDir, (String)this.scd.getSpringBootAppNodeLocation().get()) : new File(appsDir, "thin-" + archiveSrc.getName());
        return archiveTarget;
    }

    private File getLibIndexCacheTarget() {
        File sharedDirectory = new File(this.userDirectory, "shared");
        File sharedResourcesDirectory = new File(sharedDirectory, "resources");
        if (!sharedResourcesDirectory.exists()) {
            sharedResourcesDirectory.mkdirs();
        }
        File libIndexCacheTarget = new File(sharedResourcesDirectory, "lib.index.cache");
        return libIndexCacheTarget;
    }

    protected void installDependencies() throws MojoExecutionException, IOException {
        Set artifacts = this.project.getArtifacts();
        this.getLog().debug((CharSequence)("Number of compile dependencies for " + this.project.getArtifactId() + " : " + artifacts.size()));
        for (Artifact artifact : artifacts) {
            if (!this.isSupportedType(artifact.getType())) {
                this.getLog().debug((CharSequence)("Skipping install of dependency " + artifact.getArtifactId() + " with unsupported type: " + artifact.getType()));
                continue;
            }
            if (this.assemblyArtifact != null && this.matches(artifact, this.assemblyArtifact) || !artifact.getScope().equals("compile")) continue;
            if (this.isSupportedType(artifact.getType())) {
                if (this.looseApplication && this.isReactorMavenProject(artifact)) {
                    MavenProject dependProj = this.getReactorMavenProject(artifact);
                    this.installLooseApplication(dependProj);
                    continue;
                }
                this.installApp(this.resolveArtifact(artifact));
                continue;
            }
            this.getLog().warn((CharSequence)MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    protected void installProject() throws MojoExecutionException, IOException {
        if (this.isSupportedType(this.project.getPackaging())) {
            if (this.looseApplication) {
                this.installLooseApplication(this.project);
            } else {
                this.installApp(this.project.getArtifact());
            }
        } else {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    private void installLooseApplication(MavenProject proj) throws MojoExecutionException, IOException {
        String looseConfigFileName = this.getLooseConfigFileName(proj);
        String application = looseConfigFileName.substring(0, looseConfigFileName.length() - 4);
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        File looseConfigFile = new File(destDir, looseConfigFileName);
        File applicationFullPath = new File(destDir, application);
        File devcDestDir = new File(new File(this.project.getBuild().getDirectory(), ".libertyDevc"), this.getAppsDirectory());
        File devcLooseConfigFile = new File(devcDestDir, looseConfigFileName);
        LooseConfigData config = DeployMojo.createLooseConfigData();
        switch (proj.getPackaging()) {
            case "war": {
                this.validateAppConfig(applicationFullPath.getCanonicalPath(), application, proj.getArtifactId());
                this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                this.installLooseConfigWar(proj, config, false);
                this.installAndVerifyApp(config, looseConfigFile, application);
                if (!proj.getProperties().containsKey("container")) break;
                config = DeployMojo.createLooseConfigData();
                this.installLooseConfigWar(proj, config, true);
                try {
                    config.toXmlFile(devcLooseConfigFile);
                    break;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error writing loose application configuration file: " + devcLooseConfigFile.getCanonicalPath(), e);
                }
            }
            case "ear": {
                this.validateAppConfig(applicationFullPath.getCanonicalPath(), application, proj.getArtifactId());
                this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                this.installLooseConfigEar(proj, config, false);
                this.installAndVerifyApp(config, looseConfigFile, application);
                if (!proj.getProperties().containsKey("container")) break;
                config = DeployMojo.createLooseConfigData();
                this.installLooseConfigEar(proj, config, true);
                try {
                    config.toXmlFile(devcLooseConfigFile);
                    break;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error writing loose application configuration file: " + devcLooseConfigFile.getCanonicalPath(), e);
                }
            }
            case "liberty-assembly": {
                if (this.mavenWarPluginExists(proj) || new File(proj.getBasedir(), "src/main/webapp").exists()) {
                    this.validateAppConfig(applicationFullPath.getCanonicalPath(), application, proj.getArtifactId());
                    this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                    this.installLooseConfigWar(proj, config, false);
                    this.installAndVerifyApp(config, looseConfigFile, application);
                    if (!proj.getProperties().containsKey("container")) break;
                    config = DeployMojo.createLooseConfigData();
                    this.installLooseConfigWar(proj, config, true);
                    try {
                        config.toXmlFile(devcLooseConfigFile);
                        break;
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Error writing loose application configuration file: " + devcLooseConfigFile.getCanonicalPath(), e);
                    }
                }
                this.getLog().debug((CharSequence)"The liberty-assembly project does not contain the maven-war-plugin or src/main/webapp does not exist.");
                break;
            }
            default: {
                this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.loose.application.not.supported"), proj.getPackaging()));
                this.installApp(proj.getArtifact());
            }
        }
    }

    private void installAndVerifyApp(LooseConfigData config, File looseConfigFile, String applicationName) throws MojoExecutionException, IOException {
        this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
        this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
        try {
            config.toXmlFile(looseConfigFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error writing loose application file " + looseConfigFile + " from configuration data.", e);
        }
        this.verifyAppStarted(applicationName);
    }

    private static LooseConfigData createLooseConfigData() throws MojoExecutionException {
        try {
            return new LooseConfigData();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MojoExecutionException("Unable to create new LooseConfigData due to exception.", (Exception)parserConfigurationException);
        }
    }

    private void cleanupPreviousExecution() {
        if (ApplicationXmlDocument.getApplicationXmlFile((File)this.serverDirectory).exists()) {
            ApplicationXmlDocument.getApplicationXmlFile((File)this.serverDirectory).delete();
            this.scd = null;
        }
    }

    private boolean mavenWarPluginExists(MavenProject proj) {
        for (MavenProject currentProject = proj; currentProject != null; currentProject = currentProject.getParent()) {
            ArrayList plugins = new ArrayList(currentProject.getBuildPlugins());
            plugins.addAll(currentProject.getPluginManagement().getPlugins());
            for (Object o : plugins) {
                Plugin plugin;
                if (!(o instanceof Plugin) || !(plugin = (Plugin)o).getGroupId().equals("org.apache.maven.plugins") || !plugin.getArtifactId().equals("maven-war-plugin")) continue;
                return true;
            }
        }
        return false;
    }
}

