/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ExecuteMojoUtil {
    private static final ArrayList<String> COMPILE_PARAMS = new ArrayList<String>(Arrays.asList("annotationProcessorPaths", "annotationProcessors", "compilerArgs", "compilerArgument", "compilerArguments", "compilerId", "compilerReuseStrategy", "compilerVersion", "debug", "debuglevel", "encoding", "excludes", "executable", "failOnError", "failOnWarning", "fileExtensions", "forceJavacCompilerUse", "fork", "generatedSourcesDirectory", "includes", "jdkToolchain", "maxmem", "meminitial", "multiReleaseOutput", "optimize", "outputFileName", "parameters", "proc", "release", "showDeprecation", "showWarnings", "skipMain", "skipMultiThreadWarning", "source", "staleMillis", "target", "useIncrementalCompilation", "verbose"));
    private static final ArrayList<String> TEST_COMPILE_PARAMS = new ArrayList<String>(Arrays.asList("annotationProcessorPaths", "annotationProcessors", "compilerArgs", "compilerArgument", "compilerArguments", "compilerId", "compilerReuseStrategy", "compilerVersion", "debug", "debuglevel", "encoding", "executable", "failOnError", "failOnWarning", "fileExtensions", "forceJavacCompilerUse", "fork", "generatedTestSourcesDirectory", "jdkToolchain", "maxmem", "meminitial", "optimize", "outputFileName", "parameters", "proc", "release", "showDeprecation", "showWarnings", "skip", "skipMultiThreadWarning", "source", "staleMillis", "target", "testCompilerArgument", "testCompilerArguments", "testExcludes", "testIncludes", "testRelease", "testSource", "testTarget", "useIncrementalCompilation", "verbose"));
    private static final ArrayList<String> RESOURCES_PARAMS = new ArrayList<String>(Arrays.asList("outputDirectory", "resources", "addDefaultExcludes", "delimiters", "encoding", "escapeString", "escapeWindowsPaths", "fileNameFiltering", "filters", "includeEmptyDirs", "mavenFilteringHints", "nonFilteredFileExtensions", "overwrite", "skip", "supportMultiLineFiltering", "useBuildFilters", "useDefaultDelimiters"));
    private static final ArrayList<String> TEST_RESOURCES_PARAMS = new ArrayList<String>(Arrays.asList("outputDirectory", "resources", "addDefaultExcludes", "delimiters", "encoding", "escapeString", "escapeWindowsPaths", "fileNameFiltering", "filters", "includeEmptyDirs", "mavenFilteringHints", "nonFilteredFileExtensions", "overwrite", "skip", "supportMultiLineFiltering", "useBuildFilters", "useDefaultDelimiters"));
    private static final ArrayList<String> TEST_PARAMS = new ArrayList<String>(Arrays.asList("testSourceDirectory", "additionalClasspathElements", "argLine", "basedir", "childDelegation", "classesDirectory", "classpathDependencyExcludes", "classpathDependencyScopeExclude", "debugForkedProcess", "dependenciesToScan", "disableXmlReport", "enableAssertions", "encoding", "environmentVariables", "excludedGroups", "excludes", "excludesFile", "failIfNoSpecifiedTests", "failIfNoTests", "forkCount", "forkMode", "forkedProcessExitTimeoutInSeconds", "forkedProcessTimeoutInSeconds", "groups", "includes", "includesFile", "junitArtifactName", "junitPlatformArtifactName", "jvm", "objectFactory", "parallel", "parallelOptimized", "parallelTestsTimeoutForcedInSeconds", "parallelTestsTimeoutInSeconds", "perCoreThreadCount", "printSummary", "properties", "redirectTestOutputToFile", "remoteRepositories", "reportFormat", "reportNameSuffix", "reportsDirectory", "rerunFailingTestsCount", "reuseForks", "runOrder", "shutdown", "skip", "skipAfterFailureCount", "skipExec", "skipTests", "suiteXmlFiles", "systemProperties", "systemPropertiesFile", "systemPropertyVariables", "tempDir", "test", "testClassesDirectory", "testFailureIgnore", "testNGArtifactName", "threadCount", "threadCountClasses", "threadCountMethods", "threadCountSuites", "trimStackTrace", "useFile", "useManifestOnlyJar", "useModulePath", "useSystemClassLoader", "useUnlimitedThreads", "workingDirectory"));
    private static final ArrayList<String> INTEGRATION_TEST_PARAMS = new ArrayList<String>(Arrays.asList("summaryFile", "testSourceDirectory", "additionalClasspathElements", "argLine", "basedir", "childDelegation", "classesDirectory", "classpathDependencyExcludes", "classpathDependencyScopeExclude", "debugForkedProcess", "dependenciesToScan", "disableXmlReport", "enableAssertions", "encoding", "environmentVariables", "excludedGroups", "excludes", "excludesFile", "failIfNoSpecifiedTests", "failIfNoTests", "forkCount", "forkMode", "forkedProcessExitTimeoutInSeconds", "forkedProcessTimeoutInSeconds", "groups", "includes", "includesFile", "junitArtifactName", "junitPlatformArtifactName", "jvm", "objectFactory", "parallel", "parallelOptimized", "parallelTestsTimeoutForcedInSeconds", "parallelTestsTimeoutInSeconds", "perCoreThreadCount", "printSummary", "properties", "redirectTestOutputToFile", "remoteRepositories", "reportFormat", "reportNameSuffix", "reportsDirectory", "rerunFailingTestsCount", "reuseForks", "runOrder", "shutdown", "skip", "skipAfterFailureCount", "skipExec", "skipITs", "skipTests", "suiteXmlFiles", "systemProperties", "systemPropertiesFile", "systemPropertyVariables", "tempDir", "test", "testClassesDirectory", "testNGArtifactName", "threadCount", "threadCountClasses", "threadCountMethods", "threadCountSuites", "trimStackTrace", "useFile", "useManifestOnlyJar", "useModulePath", "useSystemClassLoader", "useUnlimitedThreads", "workingDirectory"));
    private static final ArrayList<String> VERIFY_PARAMS = new ArrayList<String>(Arrays.asList("summaryFile", "basedir", "encoding", "failIfNoTests", "reportsDirectory", "skip", "skipExec", "skipITs", "skipTests", "summaryFiles", "testClassesDirectory", "testFailureIgnore"));
    private static final ArrayList<String> REPORT_ONLY_PARAMS = new ArrayList<String>(Arrays.asList("outputName", "showSuccess", "aggregate", "alwaysGenerateSurefireReport", "description", "linkXRef", "reportsDirectories", "reportsDirectory", "skipSurefireReport", "title", "xrefLocation"));
    private static final ArrayList<String> FAILSAFE_REPORT_ONLY_PARAMS = REPORT_ONLY_PARAMS;
    private static final ArrayList<String> EXPLODED_PARAMS = new ArrayList<String>(Arrays.asList("warSourceDirectory", "webappDirectory", "workDirectory", "containerConfigXML", "delimiters", "dependentWarExcludes", "dependentWarIncludes", "escapedBackslashesInFilePath", "escapeString", "failOnMissingWebXml", "filteringDeploymentDescriptors", "filters", "includeEmptyDirectories", "nonFilteredFileExtensions", "outdatedCheckPath", "outputFileNameMapping", "outputTimestamp", "overlays", "propertiesEncoding", "recompressZippedFiles", "resourceEncoding", "supportMultiLineFiltering", "useDefaultDelimiters", "useJvmChmod", "warSourceExcludes", "warSourceIncludes", "webResources", "webXml"));
    private static final ArrayList<String> EAR_PARAMS = new ArrayList<String>(Arrays.asList("earSourceDirectory", "outputDirectory", "outputFileNameMapping", "tempFolder", "workDirectory", "applicationXml", "archive", "artifactTypeMappings", "classifier", "defaultLibBundleDir", "earSourceExcludes", "earSourceIncludes", "encoding", "escapeString", "escapedBackslashesInFilePath", "fileNameMapping", "filtering", "filters", "generatedDescriptorLocation", "includeLibInApplicationXml", "jboss", "mainArtifactId", "modules", "nonFilteredFileExtensions", "outputTimestamp", "packagingExcludes", "packagingIncludes", "skinnyModules", "skinnyWars", "skipClassPathModification", "unpackTypes", "useBaseVersion", "useJvmChmod", "version"));
    private static final ArrayList<String> JAR_PARAMS = new ArrayList<String>(Arrays.asList("classesDirectory", "outputDirectory", "archive", "classifier", "excludes", "forceCreation", "includes", "outputTimestamp", "skipIfEmpty", "useDefaultManifestFile"));
    private static final ArrayList<String> EJB_PARAMS = new ArrayList<String>(Arrays.asList("sourceDirectory", "archive", "classifier", "clientClassifier", "clientExcludes", "clientIncludes", "ejbJar", "ejbVersion", "escapeBackslashesInFilePath", "escapeString", "excludes", "filterDeploymentDescriptor", "filters", "generateClient", "outputTimestamp"));
    private static final ArrayList<String> BUNDLE_PARAMS = new ArrayList<String>(Arrays.asList("archive", "buildDirectory", "classifier", "createDependencyReducedPom", "dependencyReducedPomLocation", "dumpClasspath", "dumpInstructions", "excludeDependencies", "exportScr", "finalName", "instructions", "manifestLocation", "niceManifest", "noWarningProjectTypes", "outputDirectory", "packaging", "scrLocation", "supportedProjectTypes", "unpackbundle"));
    private static final ArrayList<String> WAR_PARAMS = new ArrayList<String>(Arrays.asList("outputDirectory", "warSourceDirectory", "webappDirectory", "workDirectory", "archive", "archiveClasses", "attachClasses", "classesClassifier", "classifier", "containerConfigXML", "delimiters", "dependentWarExcludes", "dependentWarIncludes", "escapeString", "escapedBackslashesInFilePath", "failOnMissingWebXml", "filteringDeploymentDescriptors", "filters", "includeEmptyDirectories", "nonFilteredFileExtensions", "outdatedCheckPath", "outputFileNameMapping", "outputTimestamp", "overlays", "packagingExcludes", "packagingIncludes", "primaryArtifact", "recompressZippedFiles", "resourceEncoding", "skip", "supportMultiLineFiltering", "useDefaultDelimiters", "useJvmChmod", "warSourceExcludes", "warSourceIncludes", "webResources", "webXml"));
    private static final ArrayList<String> EAR_GENERATE_APPLICATION_XML_PARAMS = new ArrayList<String>(Arrays.asList("outputFileNameMapping", "tempFolder", "workDirectory", "applicationId", "applicationName", "artifactTypeMappings", "defaultLibBundleDir", "description", "displayName", "ejbRefs", "encoding", "envEntries", "fileNameMapping", "generateApplicationXml", "generateModuleId", "generatedDescriptorLocation", "includeLibInApplicationXml", "initializeInOrder", "jboss", "libraryDirectoryMode", "mainArtifactId", "modules", "resourceRefs", "security", "useBaseVersion", "version"));
    private static final ArrayList<String> LIBERTY_COMMON_PARAMS = new ArrayList<String>(Arrays.asList("installDirectory", "assemblyArchive", "assemblyArtifact", "libertyRuntimeVersion", "install", "licenseArtifact", "serverName", "userDirectory", "outputDirectory", "assemblyInstallDirectory", "refresh", "skip", "serverXmlFile", "configDirectory", "serverEnvFile", "mergeServerEnv"));
    private static final ArrayList<String> LIBERTY_COMMON_SERVER_PARAMS = new ArrayList<String>(Arrays.asList("copyDependencies", "bootstrapProperties", "bootstrapPropertiesFile", "jvmOptions", "jvmOptionsFile"));
    private static final ArrayList<String> CREATE_PARAMS = new ArrayList<String>(Arrays.asList("template", "libertySettingsFolder", "noPassword"));
    private static final ArrayList<String> DEPLOY_PARAMS;
    private static final ArrayList<String> INSTALL_FEATURE_PARAMS;
    private static final ArrayList<String> GENERATE_FEATURES_PARAMS;
    private static final Map<String, String> LIBERTY_ALIAS_MAP;

    public static Xpp3Dom getPluginGoalConfig(Plugin plugin, String goal, Log log) {
        Xpp3Dom config = null;
        String execId = "default";
        int numExec = 0;
        List executions = plugin.getExecutions().stream().sorted(Comparator.comparing(PluginExecution::getPriority).reversed()).collect(Collectors.toList());
        if (!executions.isEmpty()) {
            for (PluginExecution e : executions) {
                if (e.getGoals() == null || !e.getGoals().contains(goal)) continue;
                if (numExec == 0) {
                    config = (Xpp3Dom)e.getConfiguration();
                    execId = e.getId();
                }
                ++numExec;
            }
            if (config == null) {
                config = (Xpp3Dom)plugin.getConfiguration();
            }
        } else {
            config = (Xpp3Dom)plugin.getConfiguration();
        }
        if (numExec > 1) {
            log.warn((CharSequence)(plugin.getArtifactId() + ":" + goal + " goal has multiple execution configurations (default to \"" + execId + "\" execution)"));
        }
        if (config == null) {
            config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        } else {
            config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (Xpp3Dom)config);
            config = ExecuteMojoUtil.validateConfiguration(plugin, goal, config, log);
        }
        log.debug((CharSequence)(plugin.getArtifactId() + ":" + goal + " configuration\n" + config));
        return config;
    }

    private static Xpp3Dom validateConfiguration(Plugin plugin, String goal, Xpp3Dom config, Log log) {
        Xpp3Dom goalConfig;
        String executionGoal;
        switch (executionGoal = plugin.getArtifactId() + ":" + goal) {
            case "liberty-maven-plugin:create": {
                config = ExecuteMojoUtil.convertLibertyAlias(config);
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, CREATE_PARAMS);
                break;
            }
            case "liberty-maven-plugin:deploy": {
                config = ExecuteMojoUtil.convertLibertyAlias(config);
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, DEPLOY_PARAMS);
                break;
            }
            case "liberty-maven-plugin:install-feature": {
                config = ExecuteMojoUtil.convertLibertyAlias(config);
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, INSTALL_FEATURE_PARAMS);
                break;
            }
            case "liberty-maven-plugin:generate-features": {
                config = ExecuteMojoUtil.convertLibertyAlias(config);
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, GENERATE_FEATURES_PARAMS);
                break;
            }
            case "maven-compiler-plugin:compile": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, COMPILE_PARAMS);
                break;
            }
            case "maven-compiler-plugin:testCompile": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, TEST_COMPILE_PARAMS);
                break;
            }
            case "maven-resources-plugin:resources": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, RESOURCES_PARAMS);
                break;
            }
            case "maven-resources-plugin:testResources": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, TEST_RESOURCES_PARAMS);
                break;
            }
            case "maven-surefire-plugin:test": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, TEST_PARAMS);
                break;
            }
            case "maven-failsafe-plugin:integration-test": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, INTEGRATION_TEST_PARAMS);
                break;
            }
            case "maven-failsafe-plugin:verify": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, VERIFY_PARAMS);
                break;
            }
            case "maven-surefire-report-plugin:report-only": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, REPORT_ONLY_PARAMS);
                break;
            }
            case "maven-surefire-report-plugin:failsafe-report-only": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, FAILSAFE_REPORT_ONLY_PARAMS);
                break;
            }
            case "maven-war-plugin:exploded": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, EXPLODED_PARAMS);
                break;
            }
            case "maven-ear-plugin:generate-application-xml": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, EAR_GENERATE_APPLICATION_XML_PARAMS);
                break;
            }
            case "maven-ear-plugin:ear": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, EAR_PARAMS);
                break;
            }
            case "maven-jar-plugin:jar": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, JAR_PARAMS);
                break;
            }
            case "maven-ejb-plugin:ejb": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, EJB_PARAMS);
                break;
            }
            case "maven-bundle-plugin:bundle": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, BUNDLE_PARAMS);
                break;
            }
            case "maven-war-plugin:war": {
                goalConfig = ExecuteMojoUtil.stripConfigElements(config, WAR_PARAMS);
                break;
            }
            case "liberty-maven-plugin:dev": {
                goalConfig = config;
                break;
            }
            default: {
                goalConfig = config;
                log.debug((CharSequence)("skip execution goal configuration validation for " + executionGoal));
            }
        }
        return goalConfig;
    }

    private static Xpp3Dom convertLibertyAlias(Xpp3Dom config) {
        for (String key : LIBERTY_ALIAS_MAP.keySet()) {
            Xpp3Dom alias = config.getChild(key);
            if (alias == null) continue;
            if ("runtimeArtifact".contentEquals(key)) {
                Xpp3Dom artifact = new Xpp3Dom(LIBERTY_ALIAS_MAP.get(key));
                for (Xpp3Dom child : alias.getChildren()) {
                    artifact.addChild(child);
                }
                config.addChild(artifact);
                continue;
            }
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)LIBERTY_ALIAS_MAP.get(key)), (String)alias.getValue());
            config.addChild(e.toDom());
        }
        return config;
    }

    private static Xpp3Dom stripConfigElements(Xpp3Dom config, ArrayList<String> goalParams) {
        ArrayList<Integer> removeChildren = new ArrayList<Integer>();
        for (int i = 0; i < config.getChildCount(); ++i) {
            if (goalParams.contains(config.getChild(i).getName().trim())) continue;
            removeChildren.add(i);
        }
        Collections.reverse(removeChildren);
        Iterator iterator = removeChildren.iterator();
        while (iterator.hasNext()) {
            int child = (Integer)iterator.next();
            config.removeChild(child);
        }
        return config;
    }

    static {
        CREATE_PARAMS.addAll(LIBERTY_COMMON_PARAMS);
        CREATE_PARAMS.addAll(LIBERTY_COMMON_SERVER_PARAMS);
        DEPLOY_PARAMS = new ArrayList<String>(Arrays.asList("appsDirectory", "stripVersion", "deployPackages", "timeout", "looseApplication", "copyLibsDirectory"));
        DEPLOY_PARAMS.addAll(LIBERTY_COMMON_PARAMS);
        DEPLOY_PARAMS.addAll(LIBERTY_COMMON_SERVER_PARAMS);
        INSTALL_FEATURE_PARAMS = new ArrayList<String>(Arrays.asList("features"));
        INSTALL_FEATURE_PARAMS.addAll(LIBERTY_COMMON_PARAMS);
        GENERATE_FEATURES_PARAMS = LIBERTY_COMMON_PARAMS;
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("runtimeArtifact", "assemblyArtifact");
        tempMap.put("runtimeArchive", "assemblyArchive");
        tempMap.put("runtimeInstallDirectory", "assemblyInstallDirectory");
        tempMap.put("configFile", "serverXmlFile");
        tempMap.put("serverEnv", "serverEnvFile");
        tempMap.put("installAppPackages", "deployPackages");
        LIBERTY_ALIAS_MAP = Collections.unmodifiableMap(tempMap);
    }
}

