/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.common.plugins.config.XmlDocument;
import io.openliberty.tools.maven.Install;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Profile;
import org.w3c.dom.Element;

public class PluginConfigXmlDocument
extends XmlDocument {
    private PluginConfigXmlDocument() {
    }

    public static PluginConfigXmlDocument newInstance(String rootElement) throws ParserConfigurationException {
        PluginConfigXmlDocument configDocument = new PluginConfigXmlDocument();
        configDocument.createDocument(rootElement);
        return configDocument;
    }

    public void createElement(String key, boolean value) {
        this.createElement(this.doc.getDocumentElement(), key, Boolean.toString(value));
    }

    public void createElement(Element element, String key, boolean value) {
        this.createElement(element, key, Boolean.toString(value));
    }

    public void createElement(String key, File value) throws IOException {
        if (value == null) {
            return;
        }
        this.createElement(this.doc.getDocumentElement(), key, value.getCanonicalPath());
    }

    public void createElement(String name, Map<String, String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Element child = this.doc.createElement(name);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.createElement(child, entry.getKey(), entry.getValue());
        }
        this.doc.getDocumentElement().appendChild(child);
    }

    public void createElement(String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Element child = this.doc.createElement(name);
        for (int i = 0; i < values.size(); ++i) {
            this.createElement(child, "param", values.get(i));
        }
        this.doc.getDocumentElement().appendChild(child);
    }

    public void createElement(String name, Dependency value) {
        if (value == null) {
            return;
        }
        Element child = this.doc.createElement(name);
        this.createElement(child, "groupId", value.getGroupId());
        this.createElement(child, "artifactId", value.getArtifactId());
        this.createElement(child, "version", value.getVersion());
        this.createElement(child, "type", value.getType());
        this.doc.getDocumentElement().appendChild(child);
    }

    public void createElement(String name, Install value) {
        if (value == null) {
            return;
        }
        Element child = this.doc.createElement(name);
        this.createElement(child, "cacheDirectory", value.getCacheDirectory());
        this.createElement(child, "licenseCode", value.getLicenseCode());
        this.createElement(child, "type", value.getType());
        this.createElement(child, "version", value.getVersion());
        this.createElement(child, "runtimeUrl", value.getRuntimeUrl());
        this.createElement(child, "username", value.getUsername());
        this.createElement(child, "password", "*********");
        this.createElement(child, "maxDownloadTime", Long.toString(value.getMaxDownloadTime()));
        this.createElement(child, "runtimeUrl", value.getRuntimeUrl());
        this.createElement(child, "verbose", value.isVerbose());
        this.doc.getDocumentElement().appendChild(child);
    }

    public void createElement(String key, String value) {
        this.createElement(this.doc.getDocumentElement(), key, value);
    }

    public void createElement(Element elem, String key, String value) {
        if (value == null) {
            return;
        }
        Element child = this.doc.createElement(key);
        child.appendChild(this.doc.createTextNode(value));
        elem.appendChild(child);
    }

    public void createActiveBuildProfilesElement(String name, List<Profile> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        Element child = this.doc.createElement(name);
        for (int i = 0; i < value.size(); ++i) {
            this.createElement(child, "profileId", value.get(i).getId());
        }
        this.doc.getDocumentElement().appendChild(child);
    }
}

