/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import java.io.File;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectUtil {
    public static String getPluginConfiguration(MavenProject proj, String pluginGroupId, String pluginArtifactId, String key) {
        return MavenProjectUtil.getPluginExecutionConfiguration(proj, pluginGroupId, pluginArtifactId, null, key);
    }

    public static String getPluginExecutionConfiguration(MavenProject proj, String pluginGroupId, String pluginArtifactId, String executionId, String key) {
        Xpp3Dom val;
        Xpp3Dom dom = proj.getGoalConfiguration(pluginGroupId, pluginArtifactId, executionId, null);
        if (dom != null && (val = dom.getChild(key)) != null) {
            return val.getValue();
        }
        return null;
    }

    public static String getAppNameClassifier(MavenProject proj) {
        Xpp3Dom classifier;
        String pluginName = null;
        if (proj.getPackaging().equals("jar")) {
            pluginName = "maven-jar-plugin";
        } else if (proj.getPackaging().equals("war")) {
            pluginName = "maven-war-plugin";
        } else if (proj.getPackaging().equals("ear")) {
            pluginName = "maven-ear-plugin";
        } else if (proj.getPackaging().equals("bundle")) {
            pluginName = "maven-bundle-plugin";
        } else {
            return null;
        }
        Xpp3Dom dom = proj.getGoalConfiguration("org.apache.maven.plugins", pluginName, null, null);
        if (dom != null && (classifier = dom.getChild("classifier")) != null) {
            return classifier.getValue();
        }
        return null;
    }

    public static String getPluginGoalConfigurationString(MavenProject project, String pluginKey, String goal, String configName) throws PluginScenarioException {
        Xpp3Dom configElement;
        PluginExecution execution = MavenProjectUtil.getPluginGoalExecution(project, pluginKey, goal);
        Xpp3Dom config = (Xpp3Dom)execution.getConfiguration();
        if (config != null && (configElement = config.getChild(configName)) != null) {
            String value = configElement.getValue().trim();
            return value;
        }
        throw new PluginScenarioException("Could not find configuration string " + configName + " for goal " + goal + " on plugin " + pluginKey);
    }

    public static boolean doesPluginGoalExecutionExist(MavenProject project, String pluginKey, String goal) {
        List executions;
        boolean exists = false;
        Plugin plugin = project.getPlugin(pluginKey);
        if (plugin != null && (executions = plugin.getExecutions()) != null) {
            for (PluginExecution execution : executions) {
                if (!execution.getGoals().contains(goal)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public static PluginExecution getPluginGoalExecution(Plugin plugin, String goal) throws PluginScenarioException {
        List executions = plugin.getExecutions();
        for (PluginExecution execution : executions) {
            if (!execution.getGoals().contains(goal)) continue;
            return execution;
        }
        throw new PluginScenarioException("Could not find goal " + goal + " on plugin " + plugin.getKey());
    }

    public static PluginExecution getPluginGoalExecution(MavenProject project, String pluginKey, String goal) throws PluginScenarioException {
        Plugin plugin = project.getPlugin(pluginKey);
        if (plugin != null) {
            return MavenProjectUtil.getPluginGoalExecution(plugin, goal);
        }
        throw new PluginScenarioException("Could not find plugin " + pluginKey);
    }

    public static File getManifestFile(MavenProject proj, String pluginArtifactId) {
        String dependProjectTargetDir;
        File generatedManifest;
        Xpp3Dom val;
        Xpp3Dom archive;
        String groupId = pluginArtifactId.equals("maven-bundle-plugin") ? "org.apache.felix" : "org.apache.maven.plugins";
        Xpp3Dom dom = proj.getGoalConfiguration(groupId, pluginArtifactId, null, null);
        if (dom != null && (archive = dom.getChild("archive")) != null && (val = archive.getChild("manifestFile")) != null) {
            return new File(proj.getBasedir().getAbsolutePath() + "/" + val.getValue());
        }
        if (pluginArtifactId.equals("maven-bundle-plugin") && (generatedManifest = new File(dependProjectTargetDir = proj.getBuild().getDirectory(), "/classes/META-INF/MANIFEST.MF")).exists()) {
            return generatedManifest;
        }
        return null;
    }

    public static int getMajorPluginVersion(MavenProject project, String pluginKey) {
        Plugin plugin = project.getPlugin(pluginKey);
        if (plugin != null) {
            return Character.getNumericValue(plugin.getVersion().charAt(0));
        }
        return 0;
    }
}

