/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.server.types.Features;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class InstallFeatureSupport
extends BasicSupport {
    @Parameter
    protected Features features;
    public boolean noFeaturesSection;
    public boolean installFromAnt;

    protected Set<String> getPluginListedFeatures(boolean findEsaFiles) {
        HashSet<String> result = new HashSet<String>();
        for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
            if ((!findEsaFiles || !feature.getFeature().endsWith(".esa")) && (findEsaFiles || feature.getFeature().endsWith(".esa"))) continue;
            result.add(feature.getFeature());
            this.log.debug((CharSequence)("Plugin listed " + (findEsaFiles ? "ESA" : "feature") + ": " + feature.getFeature()));
        }
        return result;
    }

    protected Set<String> getDependencyFeatures() {
        HashSet<String> result = new HashSet<String>();
        List dependencyArtifacts = this.project.getDependencies();
        for (Dependency dependencyArtifact : dependencyArtifacts) {
            if (!"esa".equals(dependencyArtifact.getType())) continue;
            result.add(dependencyArtifact.getArtifactId());
            this.log.debug((CharSequence)("Dependency feature: " + dependencyArtifact.getArtifactId()));
        }
        return result;
    }

    protected boolean initialize() throws MojoExecutionException {
        if (this.skip) {
            return false;
        }
        if (this.features == null) {
            this.noFeaturesSection = true;
            this.features = new Features();
        }
        this.checkServerHomeExists();
        return true;
    }

    protected Set<String> getInstalledFeatures() throws PluginExecutionException {
        Set<String> pluginListedFeatures = this.getPluginListedFeatures(false);
        Set<String> pluginListedEsas = this.getPluginListedFeatures(true);
        InstallFeatureUtil util = this.getInstallFeatureUtil(pluginListedEsas);
        if (util == null && this.noFeaturesSection) {
            return new HashSet<String>();
        }
        if (util == null && !this.noFeaturesSection) {
            HashSet<String> featuresToInstall = new HashSet<String>();
            for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
                featuresToInstall.add(feature.toString());
            }
            return featuresToInstall;
        }
        Set<String> dependencyFeatures = this.getDependencyFeatures();
        Set serverFeatures = this.serverDirectory.exists() ? util.getServerFeatures(this.serverDirectory) : null;
        return InstallFeatureUtil.combineToSet((Collection[])new Collection[]{pluginListedFeatures, dependencyFeatures, serverFeatures});
    }

    protected InstallFeatureUtil getInstallFeatureUtil(Set<String> pluginListedEsas) throws PluginExecutionException {
        InstallFeatureMojoUtil util = null;
        try {
            util = new InstallFeatureMojoUtil(pluginListedEsas);
        }
        catch (PluginScenarioException e) {
            this.log.debug((CharSequence)e.getMessage());
            if (this.noFeaturesSection) {
                this.log.debug((CharSequence)"Skipping feature installation with installUtility because the features configuration element with an acceptLicense parameter was not specified for the install-feature goal.");
            }
            this.installFromAnt = true;
            this.log.debug((CharSequence)"Installing features from installUtility.");
        }
        return util;
    }

    protected class InstallFeatureMojoUtil
    extends InstallFeatureUtil {
        public InstallFeatureMojoUtil(Set<String> pluginListedEsas) throws PluginScenarioException, PluginExecutionException {
            super(InstallFeatureSupport.this.installDirectory, InstallFeatureSupport.this.features.getFrom(), InstallFeatureSupport.this.features.getTo(), pluginListedEsas);
        }

        public void debug(String msg) {
            InstallFeatureSupport.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            InstallFeatureSupport.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            InstallFeatureSupport.this.log.debug(e);
        }

        public void warn(String msg) {
            InstallFeatureSupport.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            InstallFeatureSupport.this.log.info((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return InstallFeatureSupport.this.log.isDebugEnabled();
        }

        public File downloadArtifact(String groupId, String artifactId, String type, String version) throws PluginExecutionException {
            try {
                return InstallFeatureSupport.this.getArtifact(groupId, artifactId, type, version).getFile();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }
    }
}

