/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.ant.InstallFeatureTask;
import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.maven.InstallFeatureSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="install-feature")
public class InstallFeatureMojo
extends InstallFeatureSupport {
    protected void doExecute() throws Exception {
        if (!this.initialize()) {
            return;
        }
        this.installFeatures();
    }

    private void installFeatures() throws PluginExecutionException {
        Set<String> featuresToInstall = this.getInstalledFeatures();
        Set<String> pluginListedEsas = this.getPluginListedFeatures(true);
        InstallFeatureUtil util = this.getInstallFeatureUtil(pluginListedEsas);
        if (this.installFromAnt) {
            this.installFeaturesFromAnt(this.features.getFeatures());
        } else {
            util.installFeatures(this.features.isAcceptLicense(), new ArrayList<String>(featuresToInstall));
        }
    }

    private void installFeaturesFromAnt(List<FeatureManagerTask.Feature> installFeatures) {
        InstallFeatureTask installFeatureTask;
        if (this.defaultOutputDirSet) {
            this.outputDirectory = new File(this.project.getBuild().getDirectory(), "liberty-alt-output-dir");
        }
        if ((installFeatureTask = (InstallFeatureTask)this.ant.createTask("antlib:io/openliberty/tools/ant:install-feature")) == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "install-feature"));
        }
        installFeatureTask.setInstallDir(this.installDirectory);
        installFeatureTask.setServerName(this.serverName);
        installFeatureTask.setUserDir(this.userDirectory);
        installFeatureTask.setOutputDir(this.outputDirectory);
        installFeatureTask.setAcceptLicense(this.features.isAcceptLicense());
        installFeatureTask.setTo(this.features.getTo());
        installFeatureTask.setWhenFileExists(this.features.getWhenFileExists());
        installFeatureTask.setFeatures(installFeatures);
        installFeatureTask.setFrom(this.features.getFrom());
        installFeatureTask.execute();
    }
}

