/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SpringBootUtil {
    public static String getSpringBootMavenPluginClassifier(MavenProject project, Log log) {
        String classifier = null;
        try {
            classifier = MavenProjectUtil.getPluginGoalConfigurationString(project, "org.springframework.boot:spring-boot-maven-plugin", "repackage", "classifier");
        }
        catch (PluginScenarioException e) {
            log.debug((CharSequence)"No classifier found for spring-boot-maven-plugin");
        }
        return classifier;
    }

    public static File getSpringBootUberJAR(MavenProject project, Log log) {
        File fatArchive = SpringBootUtil.getSpringBootUberJARLocation(project, log);
        if (io.openliberty.tools.common.plugins.util.SpringBootUtil.isSpringBootUberJar((File)fatArchive)) {
            log.info((CharSequence)("Found Spring Boot Uber JAR: " + fatArchive.getAbsolutePath()));
            return fatArchive;
        }
        log.warn((CharSequence)("Spring Boot Uber JAR was not found in expected location: " + fatArchive.getAbsolutePath()));
        return null;
    }

    public static File getSpringBootUberJARLocation(MavenProject project, Log log) {
        String classifier = SpringBootUtil.getSpringBootMavenPluginClassifier(project, log);
        if (classifier == null) {
            classifier = "";
        }
        if (!classifier.isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + classifier + "." + project.getArtifact().getArtifactHandler().getExtension());
    }
}

