/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.server.types.Features;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class InstallFeatureSupport
extends BasicSupport {
    @Parameter
    protected Features features;
    public boolean noFeaturesSection;
    public boolean installFromAnt;
    private InstallFeatureUtil util;
    public static final String FEATURES_JSON_ARTIFACT_ID = "features";

    protected Set<String> getPluginListedFeatures(boolean findEsaFiles) {
        HashSet<String> result = new HashSet<String>();
        for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
            if ((!findEsaFiles || !feature.getFeature().endsWith(".esa")) && (findEsaFiles || feature.getFeature().endsWith(".esa"))) continue;
            result.add(feature.getFeature());
            this.log.debug((CharSequence)("Plugin listed " + (findEsaFiles ? "ESA" : "feature") + ": " + feature.getFeature()));
        }
        return result;
    }

    protected Set<String> getDependencyFeatures() {
        HashSet<String> result = new HashSet<String>();
        List dependencyArtifacts = this.project.getDependencies();
        for (Dependency dependencyArtifact : dependencyArtifacts) {
            if (!"esa".equals(dependencyArtifact.getType())) continue;
            result.add(dependencyArtifact.getArtifactId());
            this.log.debug((CharSequence)("Dependency feature: " + dependencyArtifact.getArtifactId()));
        }
        return result;
    }

    protected List<String> getAdditionalJsonList() {
        ArrayList<String> result = new ArrayList<String>();
        DependencyManagement dependencyManagement = this.project.getDependencyManagement();
        if (dependencyManagement == null) {
            this.log.debug((CharSequence)"Feature-bom is not provided by the user");
            return null;
        }
        List dependencyManagementArtifacts = dependencyManagement.getDependencies();
        for (Dependency dependencyArtifact : dependencyManagementArtifacts) {
            if (!"pom".equals(dependencyArtifact.getType())) continue;
            String coordinate = String.format("%s:%s:%s", dependencyArtifact.getGroupId(), FEATURES_JSON_ARTIFACT_ID, dependencyArtifact.getVersion());
            result.add(coordinate);
            this.log.info((CharSequence)("Additional user feature json coordinate: " + coordinate));
        }
        return result;
    }

    protected boolean initialize() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping install-feature goal.\n");
            return false;
        }
        if (this.features == null) {
            this.noFeaturesSection = true;
            this.features = new Features();
        }
        this.checkServerHomeExists();
        return true;
    }

    protected Set<String> getSpecifiedFeatures(String containerName) throws PluginExecutionException {
        Set<String> pluginListedFeatures = this.getPluginListedFeatures(false);
        if (this.util == null) {
            Set<String> pluginListedEsas = this.getPluginListedFeatures(true);
            Object propertiesList = null;
            String openLibertyVersion = null;
            if (containerName == null) {
                propertiesList = InstallFeatureUtil.loadProperties((File)this.installDirectory);
                openLibertyVersion = InstallFeatureUtil.getOpenLibertyVersion((List)propertiesList);
            }
            List<String> additionalJsons = this.getAdditionalJsonList();
            this.createNewInstallFeatureUtil(pluginListedEsas, (List<InstallFeatureUtil.ProductProperties>)propertiesList, openLibertyVersion, containerName, additionalJsons);
        }
        if (this.util == null && this.noFeaturesSection) {
            return new HashSet<String>();
        }
        if (this.util == null && !this.noFeaturesSection) {
            HashSet<String> featuresToInstall = new HashSet<String>();
            for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
                featuresToInstall.add(feature.toString());
            }
            return featuresToInstall;
        }
        Set<String> dependencyFeatures = this.getDependencyFeatures();
        Set serverFeatures = this.serverDirectory.exists() ? this.util.getServerFeatures(this.serverDirectory, this.getLibertyDirectoryPropertyFiles()) : null;
        return InstallFeatureUtil.combineToSet((Collection[])new Collection[]{pluginListedFeatures, dependencyFeatures, serverFeatures});
    }

    private void createNewInstallFeatureUtil(Set<String> pluginListedEsas, List<InstallFeatureUtil.ProductProperties> propertiesList, String openLibertyVerion, String containerName, List<String> additionalJsons) throws PluginExecutionException {
        try {
            this.util = new InstallFeatureMojoUtil(pluginListedEsas, propertiesList, openLibertyVerion, containerName, additionalJsons);
        }
        catch (PluginScenarioException e) {
            this.log.debug((CharSequence)e.getMessage());
            if (this.noFeaturesSection) {
                this.log.debug((CharSequence)"Skipping feature installation with installUtility because the features configuration element with an acceptLicense parameter was not specified for the install-feature goal.");
            }
            if (additionalJsons != null && !additionalJsons.isEmpty()) {
                this.log.debug((CharSequence)"Skipping feature installation with installUtility because it is not supported for user feature");
            }
            this.installFromAnt = true;
            this.log.debug((CharSequence)"Installing features from installUtility.");
        }
    }

    protected InstallFeatureUtil getInstallFeatureUtil(Set<String> pluginListedEsas, List<InstallFeatureUtil.ProductProperties> propertiesList, String openLibertyVerion, String containerName, List<String> additionalJsons) throws PluginExecutionException {
        this.createNewInstallFeatureUtil(pluginListedEsas, propertiesList, openLibertyVerion, containerName, additionalJsons);
        return this.util;
    }

    protected class InstallFeatureMojoUtil
    extends InstallFeatureUtil {
        public InstallFeatureMojoUtil(Set<String> pluginListedEsas, List<InstallFeatureUtil.ProductProperties> propertiesList, String openLibertyVerion, String containerName, List<String> additionalJsons) throws PluginScenarioException, PluginExecutionException {
            super(InstallFeatureSupport.this.installDirectory, InstallFeatureSupport.this.features.getFrom(), InstallFeatureSupport.this.features.getTo(), pluginListedEsas, propertiesList, openLibertyVerion, containerName, additionalJsons);
        }

        public void debug(String msg) {
            InstallFeatureSupport.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            InstallFeatureSupport.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            InstallFeatureSupport.this.log.debug(e);
        }

        public void warn(String msg) {
            InstallFeatureSupport.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            InstallFeatureSupport.this.log.info((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return InstallFeatureSupport.this.log.isDebugEnabled();
        }

        public void error(String msg) {
            InstallFeatureSupport.this.log.error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            InstallFeatureSupport.this.log.error((CharSequence)msg, e);
        }

        public File downloadArtifact(String groupId, String artifactId, String type, String version) throws PluginExecutionException {
            try {
                return InstallFeatureSupport.this.getArtifact(groupId, artifactId, type, version).getFile();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }
    }
}

