/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.applications;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.ant.SpringBootUtilTask;
import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.config.ApplicationXmlDocument;
import io.openliberty.tools.common.plugins.config.LooseApplication;
import io.openliberty.tools.common.plugins.config.LooseConfigData;
import io.openliberty.tools.common.plugins.config.ServerConfigDocument;
import io.openliberty.tools.common.plugins.util.DevUtil;
import io.openliberty.tools.maven.applications.LooseEarApplication;
import io.openliberty.tools.maven.applications.LooseWarApplication;
import io.openliberty.tools.maven.server.LooseAppSupport;
import io.openliberty.tools.maven.utils.CommonLogger;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.w3c.dom.Element;

public class DeployMojoSupport
extends LooseAppSupport {
    private final String PROJECT_ROOT_TARGET_LIBS = "target/libs";
    @Parameter(property="timeout", defaultValue="40")
    protected long timeout = 40L;
    @Parameter(property="copyLibsDirectory")
    protected File copyLibsDirectory;
    protected ApplicationXmlDocument applicationXml = new ApplicationXmlDocument();

    protected void installApp(Artifact artifact) throws Exception {
        if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
            String appFileName = this.getPreDeployAppFileName(this.project);
            File f = new File(this.project.getBuild().getDirectory() + "/" + appFileName);
            artifact.setFile(f);
        }
        if (!artifact.getFile().exists()) {
            throw new MojoExecutionException(messages.getString("error.install.app.missing"));
        }
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), artifact.getFile().getCanonicalPath()));
        Copy copyFile = (Copy)this.ant.createTask("copy");
        copyFile.setFile(artifact.getFile());
        String fileName = artifact.getFile().getName();
        if (this.stripVersion) {
            fileName = this.stripVersionFromName(fileName, artifact.getBaseVersion());
            copyFile.setTofile(new File(destDir, fileName));
        } else {
            copyFile.setTodir(destDir);
        }
        this.validateAppConfig(fileName, artifact.getArtifactId());
        this.deleteApplication(new File(this.serverDirectory, "apps"), artifact.getFile());
        this.deleteApplication(new File(this.serverDirectory, "dropins"), artifact.getFile());
        this.deleteApplication(new File(this.serverDirectory, "apps/expanded"), artifact.getFile());
        copyFile.execute();
        this.verifyAppStarted(fileName);
    }

    private void setLooseProjectRootForContainer(MavenProject proj, LooseConfigData config) throws MojoExecutionException {
        try {
            String projectRoot = DevUtil.getLooseAppProjectRoot((File)proj.getBasedir(), (File)this.multiModuleProjectDirectory).getCanonicalPath();
            config.setProjectRoot(projectRoot);
            config.setSourceOnDiskName("${io.openliberty.tools.projectRoot}");
            if (this.copyLibsDirectory == null) {
                this.copyLibsDirectory = new File(proj.getBasedir(), "target/libs");
            } else {
                String copyLibsPath = this.copyLibsDirectory.getCanonicalPath();
                if (!copyLibsPath.startsWith(projectRoot)) {
                    this.log.error((CharSequence)"The directory indicated by the copyLibsDirectory parameter must be within the Maven project directory when the container option is specified.");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not resolve the canonical path of the Maven project or the directory specified in the copyLibsDirectory parameter. Exception message:" + e.getMessage(), (Exception)e);
        }
    }

    protected void installLooseConfigWar(MavenProject proj, LooseConfigData config, boolean container) throws Exception {
        File dir = new File(proj.getBuild().getOutputDirectory());
        if (!dir.exists() && this.containsJavaSource(proj)) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.project.not.compile"), proj.getId()));
        }
        if (container) {
            this.setLooseProjectRootForContainer(proj, config);
        }
        LooseWarApplication looseWar = new LooseWarApplication(proj, config);
        looseWar.addSourceDir(proj);
        looseWar.addOutputDir(looseWar.getDocumentRoot(), new File(proj.getBuild().getOutputDirectory()), "/WEB-INF/classes");
        Map<String, String> webResources = MavenProjectUtil.getWebResourcesConfiguration(proj);
        if (webResources != null) {
            for (String directory : webResources.keySet()) {
                String targetPath = webResources.get(directory) == null ? "/" : "/" + webResources.get(directory);
                looseWar.addOutputDir(looseWar.getDocumentRoot(), new File(proj.getBasedir().getAbsolutePath(), directory), targetPath);
            }
        }
        this.addEmbeddedLib(looseWar.getDocumentRoot(), proj, looseWar, "/WEB-INF/lib/");
        File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-war-plugin");
        looseWar.addManifestFile(manifestFile);
    }

    protected void installLooseConfigEar(MavenProject proj, LooseConfigData config, boolean container) throws Exception {
        if (container) {
            this.setLooseProjectRootForContainer(proj, config);
        }
        LooseEarApplication looseEar = new LooseEarApplication(proj, config);
        looseEar.addSourceDir();
        looseEar.addApplicationXmlFile();
        Set artifacts = proj.getArtifacts();
        this.log.debug((CharSequence)("Number of compile dependencies for " + proj.getArtifactId() + " : " + artifacts.size()));
        block12: for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
            if (!this.isReactorMavenProject(artifact)) {
                if (looseEar.isEarSkinnyWars().booleanValue() && "war".equals(artifact.getType())) {
                    throw new MojoExecutionException("Unable to create loose configuration for the EAR application with skinnyWars package from " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ". Please set the looseApplication configuration parameter to false and try again.");
                }
                looseEar.addModuleFromM2(this.resolveArtifact(artifact));
                continue;
            }
            MavenProject dependencyProject = this.getReactorMavenProject(artifact);
            switch (artifact.getType()) {
                case "jar": {
                    looseEar.addJarModule(dependencyProject, artifact);
                    continue block12;
                }
                case "ejb": {
                    looseEar.addEjbModule(dependencyProject, artifact);
                    continue block12;
                }
                case "war": {
                    Element warArchive = looseEar.addWarModule(dependencyProject, artifact, this.getWarSourceDirectory(dependencyProject));
                    if (looseEar.isEarSkinnyWars().booleanValue()) {
                        this.addSkinnyWarLib(warArchive, dependencyProject, looseEar);
                        continue block12;
                    }
                    this.addEmbeddedLib(warArchive, dependencyProject, looseEar, "/WEB-INF/lib/");
                    continue block12;
                }
                case "rar": {
                    Element rarArchive = looseEar.addRarModule(dependencyProject, artifact);
                    this.addEmbeddedLib(rarArchive, dependencyProject, looseEar, "/");
                    continue block12;
                }
            }
            looseEar.addModuleFromM2(this.resolveArtifact(artifact));
        }
        File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-ear-plugin");
        looseEar.addManifestFile(manifestFile);
    }

    private boolean shouldValidateAppStart() throws MojoExecutionException {
        try {
            return new File(this.serverDirectory.getCanonicalPath() + "/workarea/.sRunning").exists();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not get the server directory to determine the state of the server.");
        }
    }

    protected void verifyAppStarted(String appFile) throws MojoExecutionException {
        if (this.shouldValidateAppStart()) {
            ServerTask serverTask;
            String appName = appFile.substring(0, appFile.lastIndexOf(46));
            if (this.getAppsDirectory().equals("apps")) {
                ServerConfigDocument scd = null;
                File serverXML = new File(this.serverDirectory, "server.xml");
                try {
                    scd = ServerConfigDocument.getInstance((CommonLoggerI)CommonLogger.getInstance(), (File)serverXML, (File)this.configDirectory, (File)this.bootstrapPropertiesFile, (Map)this.combinedBootstrapProperties, (File)this.serverEnvFile, (boolean)false);
                    appName = ServerConfigDocument.findNameForLocation((String)appFile);
                }
                catch (Exception e) {
                    this.log.warn((CharSequence)e.getLocalizedMessage());
                    this.log.debug((Throwable)e);
                }
            }
            if ((serverTask = this.initializeJava()).waitForStringInLog("CWWKZ0001I.*" + appName, this.timeout * 1000L, new File(new File(this.outputDirectory, this.serverName), "logs/messages.log")) == null) {
                throw new MojoExecutionException(MessageFormat.format(messages.getString("error.deploy.fail"), appName));
            }
        }
    }

    private void addEmbeddedLib(Element parent, MavenProject warProject, LooseApplication looseApp, String dir) throws Exception {
        Set artifacts = warProject.getArtifacts();
        this.log.debug((CharSequence)("Number of compile dependencies for " + warProject.getArtifactId() + " : " + artifacts.size()));
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            this.addLibrary(parent, looseApp, dir, artifact);
        }
    }

    private void addSkinnyWarLib(Element parent, MavenProject warProject, LooseEarApplication looseEar) throws Exception {
        Set artifacts = warProject.getArtifacts();
        this.log.debug((CharSequence)("Number of compile dependencies for " + warProject.getArtifactId() + " : " + artifacts.size()));
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) || !"jar".equals(artifact.getType()) || looseEar.isEarDependency(artifact)) continue;
            this.addLibrary(parent, looseEar, "/WEB-INF/lib/", artifact);
        }
    }

    private void addLibrary(Element parent, LooseApplication looseApp, String dir, Artifact artifact) throws Exception {
        if (this.isReactorMavenProject(artifact)) {
            MavenProject dependProject = this.getReactorMavenProject(artifact);
            String artifactFileName = this.getPreDeployAppFileName(dependProject);
            Element archive = looseApp.addArchive(parent, dir + artifactFileName);
            looseApp.addOutputDir(archive, new File(dependProject.getBuild().getOutputDirectory()), "/");
            String archivePlugin = dependProject.getPackaging().equalsIgnoreCase("ejb") ? "maven-ejb-plugin" : "maven-jar-plugin";
            File manifestFile = MavenProjectUtil.getManifestFile(dependProject, archivePlugin);
            String dependProjectTargetDir = dependProject.getBuild().getDirectory();
            looseApp.addManifestFileWithParent(archive, manifestFile, dependProjectTargetDir);
        } else {
            this.resolveArtifact(artifact);
            if (this.copyLibsDirectory != null) {
                if (!this.copyLibsDirectory.exists()) {
                    this.copyLibsDirectory.mkdirs();
                }
                if (!this.copyLibsDirectory.isDirectory()) {
                    throw new MojoExecutionException("copyLibsDirectory must be a directory");
                }
                looseApp.getConfig().addFile(parent, artifact.getFile(), dir + artifact.getFile().getName(), this.copyLibsDirectory);
            } else {
                looseApp.getConfig().addFile(parent, artifact.getFile(), dir + artifact.getFile().getName());
            }
        }
    }

    private boolean containsJavaSource(MavenProject proj) {
        List srcDirs = proj.getCompileSourceRoots();
        for (String dir : srcDirs) {
            File javaSourceDir = new File(dir);
            if (!javaSourceDir.exists() || !javaSourceDir.isDirectory() || !this.containsJavaSource(javaSourceDir)) continue;
            return true;
        }
        return false;
    }

    private boolean containsJavaSource(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".java")) {
                return true;
            }
            if (!file.isDirectory()) continue;
            return this.containsJavaSource(file);
        }
        return false;
    }

    protected void validateAppConfig(String fileName, String artifactId) throws Exception {
        this.validateAppConfig(fileName, artifactId, false);
    }

    protected void validateAppConfig(String fileName, String artifactId, boolean isSpringBootApp) throws Exception {
        String appsDir = this.getAppsDirectory();
        if (appsDir.equalsIgnoreCase("apps") && !this.isAppConfiguredInSourceServerXml(fileName)) {
            this.applicationXml.createApplicationElement(fileName, artifactId, isSpringBootApp);
        } else if (appsDir.equalsIgnoreCase("dropins") && this.isAppConfiguredInSourceServerXml(fileName)) {
            throw new MojoExecutionException(messages.getString("error.install.app.dropins.directory"));
        }
    }

    protected void invokeSpringBootUtilCommand(File installDirectory, String fatArchiveSrcLocation, String thinArchiveTargetLocation, String libIndexCacheTargetLocation) throws Exception {
        SpringBootUtilTask springBootUtilTask = (SpringBootUtilTask)this.ant.createTask("antlib:io/openliberty/tools/ant:springBootUtil");
        if (springBootUtilTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "springBootUtil"));
        }
        Validate.notNull((Object)fatArchiveSrcLocation, (String)"Spring Boot source archive location cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)thinArchiveTargetLocation, (String)"Target thin archive location cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)libIndexCacheTargetLocation, (String)"Library cache location cannot be null", (Object[])new Object[0]);
        springBootUtilTask.setInstallDir(installDirectory);
        springBootUtilTask.setTargetThinAppPath(thinArchiveTargetLocation);
        springBootUtilTask.setSourceAppPath(fatArchiveSrcLocation);
        springBootUtilTask.setTargetLibCachePath(libIndexCacheTargetLocation);
        springBootUtilTask.execute();
    }

    protected boolean matches(Artifact artifact, ArtifactItem assemblyArtifact) {
        return artifact.getGroupId().equals(assemblyArtifact.getGroupId()) && artifact.getArtifactId().equals(assemblyArtifact.getArtifactId()) && artifact.getType().equals(assemblyArtifact.getType());
    }

    protected boolean isSupportedType(String type) {
        boolean supported = false;
        switch (type) {
            case "ear": 
            case "war": 
            case "rar": 
            case "eba": 
            case "esa": 
            case "liberty-assembly": {
                supported = true;
                break;
            }
        }
        return supported;
    }

    public static boolean isSupportedLooseAppType(String type) {
        boolean supported = false;
        switch (type) {
            case "ear": 
            case "war": 
            case "liberty-assembly": 
            case "pom": {
                supported = true;
                break;
            }
        }
        return supported;
    }
}

