/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.applications;

import io.openliberty.tools.common.plugins.config.LooseApplication;
import io.openliberty.tools.common.plugins.config.LooseConfigData;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Element;

public class LooseEarApplication
extends LooseApplication {
    protected final MavenProject project;

    public LooseEarApplication(MavenProject project, LooseConfigData config) {
        super(project.getBuild().getDirectory(), config);
        this.project = project;
    }

    public void addSourceDir() throws Exception {
        File sourceDir = new File(this.project.getBasedir(), "src/main/application");
        String path = MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "earSourceDirectory");
        if (path != null) {
            sourceDir = new File(path);
        }
        this.config.addDir(sourceDir, "/");
    }

    public void addApplicationXmlFile() throws Exception {
        File applicationXmlFile = null;
        String path = MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "applicationXml");
        if (path != null && !path.isEmpty()) {
            applicationXmlFile = new File(path);
            this.config.addFile(applicationXmlFile, "/META-INF/application.xml");
        } else if (MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "generateApplicationXml") == null || MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "generateApplicationXml").equals("true")) {
            applicationXmlFile = new File(this.buildDirectory + "/application.xml");
            this.config.addFile(applicationXmlFile, "/META-INF/application.xml");
        }
    }

    public Element addJarModule(MavenProject proj, Artifact artifact) throws Exception {
        return this.addModule(proj, artifact, "maven-jar-plugin");
    }

    public Element addEjbModule(MavenProject proj, Artifact artifact) throws Exception {
        return this.addModule(proj, artifact, "maven-ejb-plugin");
    }

    public Element addModule(MavenProject proj, Artifact artifact, String pluginId) throws Exception {
        File outputDirectory = new File(proj.getBuild().getOutputDirectory());
        Element moduleArchive = this.config.addArchive(this.getModuleUri(artifact));
        this.config.addDir(moduleArchive, outputDirectory, "/");
        File manifestFile = MavenProjectUtil.getManifestFile(proj, pluginId);
        String mavenProjectTargetDir = proj.getBuild().getDirectory();
        this.addManifestFileWithParent(moduleArchive, manifestFile, mavenProjectTargetDir);
        this.addMetaInfFiles(moduleArchive, outputDirectory);
        return moduleArchive;
    }

    public Element addWarModule(MavenProject proj, Artifact artifact, File warSourceDir) throws Exception {
        Element warArchive = this.config.addArchive(this.getModuleUri(artifact));
        this.config.addDir(warArchive, warSourceDir, "/");
        this.config.addDir(warArchive, new File(proj.getBuild().getOutputDirectory()), "/WEB-INF/classes");
        Map<String, String> webResources = MavenProjectUtil.getWebResourcesConfiguration(proj);
        if (webResources != null) {
            for (String directory : webResources.keySet()) {
                String targetPath = webResources.get(directory) == null ? "/" : "/" + webResources.get(directory);
                this.config.addDir(warArchive, new File(proj.getBasedir().getAbsolutePath(), directory), targetPath);
            }
        }
        this.addWarManifestFile(warArchive, artifact, proj);
        return warArchive;
    }

    public Element addRarModule(MavenProject proj, Artifact artifact) throws Exception {
        Element rarArchive = this.config.addArchive(this.getModuleUri(artifact));
        this.config.addDir(rarArchive, this.getRarSourceDirectory(proj), "/");
        String path = MavenProjectUtil.getPluginConfiguration(proj, "org.apache.maven.plugins", "maven-rar-plugin", "raXmlFile");
        if (path != null && !path.isEmpty()) {
            File raXmlFile = new File(path);
            this.config.addFile(rarArchive, raXmlFile, "/META-INF/ra.xml");
        }
        String mavenProjectTargetDir = proj.getBuild().getDirectory();
        File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-rar-plugin");
        this.addManifestFileWithParent(rarArchive, manifestFile, mavenProjectTargetDir);
        return rarArchive;
    }

    public File getRarSourceDirectory(MavenProject proj) throws Exception {
        String dir = MavenProjectUtil.getPluginConfiguration(proj, "org.apache.maven.plugins", "maven-rar-plugin", "rarSourceDirectory");
        if (dir != null) {
            return new File(dir);
        }
        return new File(proj.getBasedir(), "src/main/rar");
    }

    public String getModuleUri(Artifact artifact) throws Exception {
        Xpp3Dom[] modules;
        Xpp3Dom val;
        Xpp3Dom dom;
        String defaultUri = "/" + this.getModuleName(artifact);
        String type = artifact.getType();
        if (("jar".equals(type) || "bundle".equals(type)) && this.getEarDefaultLibBundleDir() != null) {
            defaultUri = "/" + this.getEarDefaultLibBundleDir() + defaultUri;
        }
        if ((dom = this.project.getGoalConfiguration("org.apache.maven.plugins", "maven-ear-plugin", null, null)) != null && (val = dom.getChild("modules")) != null && (modules = val.getChildren()) != null) {
            for (int i = 0; i < modules.length; ++i) {
                if (!artifact.getGroupId().equals(this.getConfigValue(modules[i].getChild("groupId"))) || !artifact.getArtifactId().equals(this.getConfigValue(modules[i].getChild("artifactId")))) continue;
                String uri = this.getConfigValue(modules[i].getChild("uri"));
                if (uri != null) {
                    return uri;
                }
                String bundleDir = this.getConfigValue(modules[i].getChild("bundleDir"));
                String bundleFileName = this.getConfigValue(modules[i].getChild("bundleFileName"));
                bundleDir = bundleDir == null ? ("jar".equals(type) && this.getEarDefaultLibBundleDir() != null ? "/" + this.getEarDefaultLibBundleDir() : "") : "/" + bundleDir;
                if (bundleDir.length() > 1 && bundleDir.charAt(0) == bundleDir.charAt(1)) {
                    StringBuilder sb = new StringBuilder(bundleDir);
                    do {
                        sb.deleteCharAt(0);
                    } while (sb.length() > 1 && sb.charAt(0) == sb.charAt(1));
                    bundleDir = sb.toString();
                    if ("/".equals(bundleDir)) {
                        bundleDir = "";
                    }
                }
                if (bundleFileName != null) {
                    return bundleDir + "/" + bundleFileName;
                }
                return bundleDir + "/" + this.getModuleName(artifact);
            }
        }
        return defaultUri;
    }

    public String getConfigValue(Xpp3Dom element) {
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    public void addModuleFromM2(Artifact artifact) throws Exception {
        String artifactName = this.getModuleUri(artifact);
        this.config.addFile(artifact.getFile(), artifactName);
    }

    public String getModuleName(Artifact artifact) throws Exception {
        int earPluginVersion = MavenProjectUtil.getMajorPluginVersion(this.project, "org.apache.maven.plugins:maven-ear-plugin");
        if (earPluginVersion < 3) {
            return this.getEarFileNameMappingHelper(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
        }
        return this.getEarOutputFileNameMapping(artifact);
    }

    public String getEarFileNameMappingHelper(String groupId, String artifactId, String version, String packaging) {
        String moduleName;
        String fileExtension = packaging;
        if ("ejb".equals(fileExtension) || "app-client".equals(fileExtension) || "bundle".equals(fileExtension)) {
            fileExtension = "jar";
        }
        switch (this.getEarFileNameMapping()) {
            case "no-version": {
                moduleName = artifactId + "." + fileExtension;
                break;
            }
            case "no-version-for-ejb": {
                if ("ejb".equals(packaging)) {
                    moduleName = artifactId + "." + fileExtension;
                    break;
                }
                moduleName = artifactId + "-" + version + "." + fileExtension;
                break;
            }
            case "full": {
                moduleName = groupId + "-" + artifactId + "-" + version + "." + fileExtension;
                break;
            }
            default: {
                moduleName = artifactId + "-" + version + "." + fileExtension;
            }
        }
        return moduleName;
    }

    public String getEarOutputFileNameMapping(Artifact artifact) throws Exception {
        String outputFileNameMapping = MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "outputFileNameMapping");
        String fileNameMapping = MappingUtils.evaluateFileNameMapping((String)outputFileNameMapping, (Artifact)artifact);
        if (fileNameMapping == null || fileNameMapping.isEmpty()) {
            String defaultFormat = "@{groupId}@-@{artifactId}@-@{version}@@{dashClassifier?}@.@{extension}@";
            fileNameMapping = MappingUtils.evaluateFileNameMapping((String)defaultFormat, (Artifact)artifact);
        }
        return fileNameMapping;
    }

    public String getEarFileNameMapping() {
        String fileNameMapping = MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "fileNameMapping");
        if (fileNameMapping == null || fileNameMapping.isEmpty()) {
            fileNameMapping = "standard";
        }
        return fileNameMapping;
    }

    public String getEarDefaultLibBundleDir() {
        return MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "defaultLibBundleDir");
    }

    public Boolean isEarSkinnyWars() {
        String skinnyWars = MavenProjectUtil.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "skinnyWars");
        if (skinnyWars != null && "true".equals(skinnyWars)) {
            return true;
        }
        return false;
    }

    public void addWarManifestFile(Element parent, Artifact artifact, MavenProject proj) throws Exception {
        File newMf = new File(this.project.getBuild().getDirectory() + "/temp/" + this.getModuleUri(artifact) + "/META-INF");
        if (newMf.exists()) {
            if (this.isEarSkinnyWars().booleanValue()) {
                this.config.addDir(parent, newMf, "/META-INF");
            } else {
                File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-war-plugin");
                this.addManifestFileWithParent(parent, manifestFile, newMf.getCanonicalPath());
            }
        } else {
            String mavenProjectTargetDir = proj.getBuild().getDirectory();
            File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-war-plugin");
            this.addManifestFileWithParent(parent, manifestFile, mavenProjectTargetDir);
        }
    }

    public boolean isEarDependency(Artifact artifact) {
        Set deps = this.project.getArtifacts();
        for (Artifact dep : deps) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) || !"jar".equals(dep.getType()) || !artifact.getGroupId().equals(dep.getGroupId()) || !artifact.getArtifactId().equals(dep.getArtifactId()) || !artifact.getVersion().equals(dep.getVersion())) continue;
            return true;
        }
        return false;
    }
}

