/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.PrepareFeatureUtil;
import io.openliberty.tools.maven.BasicSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class PrepareFeatureSupport
extends BasicSupport {
    private PrepareFeatureUtil util;

    private void createNewPrepareFeatureUtil(String openLibertyVersion) throws PluginExecutionException {
        try {
            this.util = new PrepareFeatureMojoUtil(openLibertyVersion);
        }
        catch (PluginScenarioException e) {
            throw new PluginExecutionException((Throwable)e);
        }
    }

    protected List<String> getDependencyBOMs() {
        ArrayList<String> result = new ArrayList<String>();
        DependencyManagement dependencyManagement = this.project.getDependencyManagement();
        if (dependencyManagement != null) {
            List dependencyManagementArtifacts = dependencyManagement.getDependencies();
            for (Dependency dependencyArtifact : dependencyManagementArtifacts) {
                if (!"pom".equals(dependencyArtifact.getType())) continue;
                String coordinate = String.format("%s:%s:%s", dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId(), dependencyArtifact.getVersion());
                result.add(coordinate);
                this.getLog().debug((CharSequence)("Dependency BOM: " + coordinate));
            }
        }
        return result;
    }

    protected PrepareFeatureUtil getPrepareFeatureUtil(String openLibertyVersion) throws PluginExecutionException {
        this.createNewPrepareFeatureUtil(openLibertyVersion);
        return this.util;
    }

    protected class PrepareFeatureMojoUtil
    extends PrepareFeatureUtil {
        public PrepareFeatureMojoUtil(String openLibertyVersion) throws PluginScenarioException, PluginExecutionException {
            super(PrepareFeatureSupport.this.installDirectory, openLibertyVersion);
        }

        public void debug(String msg) {
            PrepareFeatureSupport.this.getLog().debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            PrepareFeatureSupport.this.getLog().debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            PrepareFeatureSupport.this.getLog().debug(e);
        }

        public void warn(String msg) {
            PrepareFeatureSupport.this.getLog().warn((CharSequence)msg);
        }

        public void info(String msg) {
            PrepareFeatureSupport.this.getLog().info((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return PrepareFeatureSupport.this.getLog().isDebugEnabled();
        }

        public void error(String msg) {
            PrepareFeatureSupport.this.getLog().error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            PrepareFeatureSupport.this.getLog().error((CharSequence)msg, e);
        }

        public File downloadArtifact(String groupId, String artifactId, String type, String version) throws PluginExecutionException {
            try {
                return PrepareFeatureSupport.this.getArtifact(groupId, artifactId, type, version).getFile();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }
    }
}

