/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.applications;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.config.ServerConfigDocument;
import io.openliberty.tools.maven.applications.DeployMojoSupport;
import io.openliberty.tools.maven.utils.CommonLogger;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="undeploy", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class UndeployAppMojo
extends DeployMojoSupport {
    private static final String STOP_APP_MESSAGE_CODE_REG = "CWWKZ0009I.*";
    private static final long APP_STOP_TIMEOUT_DEFAULT = 30000L;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping undeploy goal.\n");
            return;
        }
        this.doUndeploy();
    }

    private void doUndeploy() throws MojoExecutionException {
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        boolean uninstallDependencies = false;
        boolean uninstallProject = false;
        switch (this.getDeployPackages()) {
            case "all": {
                uninstallDependencies = true;
                uninstallProject = true;
                break;
            }
            case "dependencies": {
                uninstallDependencies = true;
                break;
            }
            case "project": {
                uninstallProject = true;
                break;
            }
            default: {
                return;
            }
        }
        if (uninstallDependencies) {
            this.undeployDependencies();
        }
        if (uninstallProject) {
            this.undeployProject();
        }
    }

    private void undeployDependencies() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!this.isSupportedType(artifact.getType()) || this.assemblyArtifact != null && this.matches(artifact, this.assemblyArtifact) || !artifact.getScope().equals("compile")) continue;
            if (this.isSupportedType(artifact.getType())) {
                if (this.looseApplication && this.isReactorMavenProject(artifact)) {
                    MavenProject dependProj = this.getReactorMavenProject(artifact);
                    this.undeployApp(new File(new File(this.serverDirectory, this.getAppsDirectory()), this.getLooseConfigFileName(dependProj)));
                    continue;
                }
                Artifact depArtifact = this.resolveArtifact(artifact);
                File depArchive = depArtifact.getFile();
                if (this.stripVersion) {
                    depArchive = new File(this.stripVersionFromName(depArtifact.getFile().getName(), depArtifact.getBaseVersion()));
                }
                File installDir = new File(this.serverDirectory, this.getAppsDirectory());
                this.undeployApp(new File(installDir, depArchive.getName()));
                continue;
            }
            this.getLog().warn((CharSequence)MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    private void undeployProject() throws MojoExecutionException {
        File installDir = new File(this.serverDirectory, this.getAppsDirectory());
        if (this.looseApplication) {
            this.undeployApp(new File(installDir, this.getLooseConfigFileName(this.project)));
        } else {
            this.undeployApp(new File(installDir, this.getPostDeployAppFileName(this.project)));
        }
    }

    protected void undeployApp(File file) throws MojoExecutionException {
        String appName = file.getName().substring(0, file.getName().lastIndexOf(46));
        if (this.getAppsDirectory().equals("apps")) {
            try {
                File serverXML = new File(this.serverDirectory.getCanonicalPath(), "server.xml");
                Map<String, File> libertyDirPropertyFiles = this.getLibertyDirectoryPropertyFiles();
                CommonLogger logger = CommonLogger.getInstance(this.getLog());
                this.setLog(logger.getLog());
                ServerConfigDocument.getInstance((CommonLoggerI)logger, (File)serverXML, (File)this.configDirectory, (File)this.bootstrapPropertiesFile, (Map)this.combinedBootstrapProperties, (File)this.serverEnvFile, (boolean)false, libertyDirPropertyFiles);
                appName = ServerConfigDocument.findNameForLocation((String)appName);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)e.getLocalizedMessage());
            }
        }
        try {
            if (!file.delete()) {
                throw new MojoExecutionException(file.toString() + " could not be deleted from the server during undeploy.");
            }
        }
        catch (SecurityException se) {
            throw new MojoExecutionException(file.toString() + " could not be deleted because access was denied.", (Exception)se);
        }
        String stopMessage = STOP_APP_MESSAGE_CODE_REG + appName;
        ServerTask serverTask = this.initializeJava();
        if (serverTask.waitForStringInLog(stopMessage, 30000L, new File(this.serverDirectory, "logs/messages.log")) == null) {
            throw new MojoExecutionException("CWWKM2022E: Failed to undeploy application " + file.getPath() + ". The Stop application message cannot be found in console.getLog().");
        }
    }
}

