/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.DevUtil;
import io.openliberty.tools.common.plugins.util.JavaCompilerOptions;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ProjectModule;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.common.plugins.util.ServerStatusUtil;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.applications.DeployMojoSupport;
import io.openliberty.tools.maven.applications.LooseWarApplication;
import io.openliberty.tools.maven.server.LooseAppSupport;
import io.openliberty.tools.maven.utils.DevHelper;
import io.openliberty.tools.maven.utils.ExecuteMojoUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="dev", requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class DevMojo
extends LooseAppSupport {
    private static final String TEST_RUN_ID_PROPERTY_NAME = "liberty.dev.test.run.id";
    private static final String LIBERTY_HOSTNAME = "liberty.hostname";
    private static final String LIBERTY_HTTP_PORT = "liberty.http.port";
    private static final String LIBERTY_HTTPS_PORT = "liberty.https.port";
    private static final String MICROSHED_HOSTNAME = "microshed_hostname";
    private static final String MICROSHED_HTTP_PORT = "microshed_http_port";
    private static final String MICROSHED_HTTPS_PORT = "microshed_https_port";
    private static final String WLP_USER_DIR_PROPERTY_NAME = "wlp.user.dir";
    private static final String GEN_FEAT_LIBERTY_DEP_WARNING = "Liberty ESA feature dependencies were detected in the pom.xml file and automatic generation of features is [On]. Automatic generation of features does not support Liberty ESA feature dependencies. Remove any Liberty ESA feature dependencies from the pom.xml file or disable automatic generation of features by typing 'g' and press Enter.";
    DevMojoUtil util = null;
    @Parameter(property="hotTests", defaultValue="false")
    private boolean hotTests;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipUTs", defaultValue="false")
    private boolean skipUTs;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="debug", defaultValue="true")
    private boolean libertyDebug;
    @Parameter(property="debugPort", defaultValue="7777")
    private int libertyDebugPort;
    @Parameter(property="container", defaultValue="false")
    private boolean container;
    @Parameter(property="generateFeatures", defaultValue="false")
    private boolean generateFeatures;
    @Parameter(property="recompileDependencies")
    private String recompileDependencies;
    @Parameter(property="compileWait", defaultValue="0.5")
    private double compileWait;
    private int runId = 0;
    private ServerTask serverTask = null;
    private Plugin boostPlugin = null;
    @Component
    protected ProjectBuilder mavenProjectBuilder;
    @Component
    private RuntimeInformation runtime;
    @Parameter(property="verifyTimeout", defaultValue="30")
    private int verifyTimeout;
    @Parameter(property="serverStartTimeout", defaultValue="90")
    private int serverStartTimeout;
    @Parameter(property="applications")
    private String applications;
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(property="pollingTest", defaultValue="false")
    protected boolean pollingTest;
    @Parameter(property="dockerfile")
    private File dockerfile;
    @Parameter(property="dockerBuildContext")
    private File dockerBuildContext;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.sourceDirectory}")
    private String sourceDirectoryString;
    private File sourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.testSourceDirectory}")
    private String testSourceDirectoryString;
    private File testSourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDirectory;
    @Parameter(property="dockerRunOpts")
    private String dockerRunOpts;
    @Parameter(property="dockerBuildTimeout", defaultValue="600")
    private int dockerBuildTimeout;
    @Parameter(property="skipDefaultPorts", defaultValue="false")
    private boolean skipDefaultPorts;
    @Parameter(property="keepTempDockerfile", defaultValue="false")
    private boolean keepTempDockerfile;
    private boolean isExplodedLooseWarApp = false;

    protected void setContainer(boolean container) {
        this.container = container;
        this.project.getProperties().setProperty("container", Boolean.toString(container));
    }

    protected List<File> getResourceDirectories(MavenProject project, File outputDir) {
        ArrayList<File> resourceDirs = new ArrayList<File>();
        for (Resource resource : project.getResources()) {
            File resourceFile = new File(resource.getDirectory());
            resourceDirs.add(resourceFile);
        }
        if (resourceDirs.isEmpty()) {
            File defaultResourceDir = new File(project.getBasedir(), "src/main/resources");
            this.getLog().debug((CharSequence)("No resource directory detected, using default directory: " + defaultResourceDir));
            resourceDirs.add(defaultResourceDir);
        }
        return resourceDirs;
    }

    private boolean isUsingBoost() {
        return this.boostPlugin != null;
    }

    private void doDevMode() throws MojoExecutionException {
        boolean recompileDeps;
        String mvnVersion = this.runtime.getMavenVersion();
        this.getLog().debug((CharSequence)("Maven version: " + mvnVersion));
        if (mvnVersion.equals("3.8.2") || mvnVersion.equals("3.8.3")) {
            throw new MojoExecutionException("Detected Maven version " + mvnVersion + ". This version is not supported for dev mode. Upgrade to Maven 3.8.4 or higher to use dev mode.");
        }
        boolean isEar = false;
        if (this.project.getPackaging().equals("ear")) {
            isEar = true;
        }
        ArrayList<MavenProject> upstreamMavenProjects = new ArrayList<MavenProject>();
        ProjectDependencyGraph graph = this.session.getProjectDependencyGraph();
        if (graph != null) {
            this.checkMultiModuleConflicts(graph);
            List downstreamProjects = graph.getDownstreamProjects(this.project, true);
            if (!downstreamProjects.isEmpty()) {
                this.getLog().debug((CharSequence)("Downstream projects: " + downstreamProjects));
                if (isEar) {
                    this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "generate-application-xml");
                    this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                    this.getOrCreateEarArtifact(this.project);
                } else if (this.project.getPackaging().equals("pom")) {
                    this.getLog().debug((CharSequence)"Skipping compile/resources on module with pom packaging type");
                } else {
                    this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                    this.runCompileMojoLogWarning();
                }
                return;
            }
            upstreamMavenProjects.addAll(graph.getUpstreamProjects(this.project, true));
            if (this.containsPreviousLibertyModule(graph)) {
                return;
            }
        }
        HashMap<String, List<String>> parentPoms = new HashMap<String, List<String>>();
        for (MavenProject proj : graph.getAllProjects()) {
            this.updateParentPoms(parentPoms, proj);
        }
        if (this.recompileDependencies == null) {
            if (upstreamMavenProjects.isEmpty()) {
                this.getLog().debug((CharSequence)"The recompileDependencies parameter was not explicitly set. The default value -DrecompileDependencies=false will be used.");
                this.recompileDependencies = "false";
            } else {
                this.getLog().debug((CharSequence)"The recompileDependencies parameter was not explicitly set. The default value for multi module projects -DrecompileDependencies=true will be used.");
                this.recompileDependencies = "true";
            }
        }
        if (recompileDeps = Boolean.parseBoolean(this.recompileDependencies)) {
            if (!upstreamMavenProjects.isEmpty()) {
                this.getLog().info((CharSequence)"The recompileDependencies parameter is set to \"true\". On a file change all dependent modules will be recompiled.");
            } else {
                this.getLog().info((CharSequence)"The recompileDependencies parameter is set to \"true\". On a file change the entire project will be recompiled.");
            }
        } else {
            this.getLog().info((CharSequence)"The recompileDependencies parameter is set to \"false\". On a file change only the affected classes will be recompiled.");
        }
        this.boostPlugin = this.project.getPlugin("org.microshed.boost:boost-maven-plugin");
        this.processContainerParams();
        if (this.serverDirectory.exists() && ServerStatusUtil.isServerRunning((File)this.installDirectory, (File)((LooseAppSupport)this).outputDirectory, (String)this.serverName)) {
            if (!this.container) {
                throw new MojoExecutionException("The server " + this.serverName + " is already running. Terminate all instances of the server before starting dev mode. You can stop a server instance with the command 'mvn liberty:stop'.");
            }
            this.getLog().warn((CharSequence)"Running server detected, which could cause unexpected results. To terminate the local running server, run the command 'mvn liberty:stop'.  Also, the warning may occur because a previous server execution did not stop cleanly, in which case you may want to run 'mvn clean' before re-running");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1, true));
        if (isEar) {
            this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "generate-application-xml");
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
        } else if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"Skipping compile/resources on module with pom packaging type");
        } else {
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
            this.runCompileMojoLogWarning();
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "testResources");
            this.runTestCompileMojoLogWarning();
        }
        this.sourceDirectory = new File(this.sourceDirectoryString.trim());
        this.testSourceDirectory = new File(this.testSourceDirectoryString.trim());
        ArrayList<File> javaFiles = new ArrayList<File>();
        this.listFiles(this.sourceDirectory, javaFiles, ".java");
        ArrayList<File> javaTestFiles = new ArrayList<File>();
        this.listFiles(this.testSourceDirectory, javaTestFiles, ".java");
        this.getLog().debug((CharSequence)("Source directory: " + this.sourceDirectory));
        this.getLog().debug((CharSequence)("Output directory: " + this.outputDirectory));
        this.getLog().debug((CharSequence)("Test Source directory: " + this.testSourceDirectory));
        this.getLog().debug((CharSequence)("Test Output directory: " + this.testOutputDirectory));
        if (this.isUsingBoost()) {
            this.getLog().info((CharSequence)"Running boost:package");
            this.runBoostMojo("package");
        } else {
            if (this.generateFeatures) {
                try {
                    String generatedFileCanonicalPath;
                    try {
                        generatedFileCanonicalPath = new File(this.configDirectory, "configDropins/overrides/generated-features.xml").getCanonicalPath();
                    }
                    catch (IOException e) {
                        generatedFileCanonicalPath = new File(this.configDirectory, "configDropins/overrides/generated-features.xml").toString();
                    }
                    this.getLog().warn((CharSequence)("The source configuration directory will be modified. Features will automatically be generated in a new file: " + generatedFileCanonicalPath));
                    this.runLibertyMojoGenerateFeatures(null, true);
                }
                catch (MojoExecutionException e) {
                    if (e.getCause() != null && e.getCause() instanceof PluginExecutionException) {
                        this.getLog().error((CharSequence)(e.getMessage() + ".\nDisabling the automatic generation of features."));
                        this.generateFeatures = false;
                    }
                    throw new MojoExecutionException(e.getMessage() + " To disable the automatic generation of features, start dev mode with -DgenerateFeatures=false.", (Exception)((Object)e));
                }
            }
            this.runLibertyMojoCreate();
            if (!this.container) {
                this.runLibertyMojoInstallFeature(null, null, null);
            }
            this.runLibertyMojoDeploy();
        }
        if (this.project.getPackaging().equals("war")) {
            Plugin warPlugin;
            this.isExplodedLooseWarApp = LooseWarApplication.isExploded(this.project);
            if (this.isExplodedLooseWarApp && !this.validatePluginVersion((warPlugin = this.getPlugin("org.apache.maven.plugins", "maven-war-plugin")).getVersion(), "3.3.2")) {
                this.getLog().warn((CharSequence)"Exploded WAR functionality is enabled. Please use maven-war-plugin version 3.3.2 or greater for best results.");
            }
        }
        List<File> resourceDirs = this.getResourceDirectories(this.project, this.outputDirectory);
        List<Path> webResourceDirs = LooseWarApplication.getFilteredWebSourceDirectories(this.project);
        JavaCompilerOptions compilerOptions = this.getMavenCompilerOptions(this.project);
        ArrayList<ProjectModule> upstreamProjects = new ArrayList<ProjectModule>();
        if (!upstreamMavenProjects.isEmpty()) {
            for (MavenProject p : upstreamMavenProjects) {
                JavaCompilerOptions upstreamCompilerOptions = this.getMavenCompilerOptions(p);
                HashSet compileArtifacts = new HashSet();
                HashSet testArtifacts = new HashSet();
                Build build = p.getBuild();
                File upstreamSourceDir = new File(build.getSourceDirectory());
                File upstreamOutputDir = new File(build.getOutputDirectory());
                File upstreamTestSourceDir = new File(build.getTestSourceDirectory());
                File upstreamTestOutputDir = new File(build.getTestOutputDirectory());
                List<File> upstreamResourceDirs = this.getResourceDirectories(p, upstreamOutputDir);
                Properties props = p.getProperties();
                Properties userProps = this.session.getUserProperties();
                Plugin libertyPlugin = this.getLibertyPluginForProject(p);
                Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "dev", this.getLog());
                boolean upstreamSkipTests = DevHelper.getBooleanFlag(config, userProps, props, "skipTests");
                boolean upstreamSkipITs = DevHelper.getBooleanFlag(config, userProps, props, "skipITs");
                boolean upstreamSkipUTs = DevHelper.getBooleanFlag(config, userProps, props, "skipUTs");
                if (p.getPackaging().equals("ear")) {
                    upstreamSkipUTs = true;
                }
                List dependentProjects = graph.getDownstreamProjects(p, true);
                ArrayList<File> dependentModules = new ArrayList<File>();
                for (MavenProject depProj : dependentProjects) {
                    dependentModules.add(depProj.getFile());
                }
                ProjectModule upstreamProject = new ProjectModule(p.getFile(), p.getArtifactId(), p.getPackaging(), compileArtifacts, testArtifacts, upstreamSourceDir, upstreamOutputDir, upstreamTestSourceDir, upstreamTestOutputDir, upstreamResourceDirs, upstreamSkipTests, upstreamSkipUTs, upstreamSkipITs, upstreamCompilerOptions, dependentModules);
                upstreamProjects.add(upstreamProject);
            }
        }
        if (isEar) {
            this.skipUTs = true;
        }
        File pom = this.project.getFile();
        try {
            HashSet<String> compileArtifactPaths = new HashSet<String>(this.project.getCompileClasspathElements());
            HashSet<String> testArtifactPaths = new HashSet<String>(this.project.getTestClasspathElements());
            this.util = new DevMojoUtil(this.installDirectory, this.userDirectory, this.serverDirectory, this.sourceDirectory, this.testSourceDirectory, this.configDirectory, this.project.getBasedir(), this.multiModuleProjectDirectory, resourceDirs, compilerOptions, this.settings.getLocalRepository(), upstreamProjects, upstreamMavenProjects, recompileDeps, pom, parentPoms, this.generateFeatures, compileArtifactPaths, testArtifactPaths, webResourceDirs);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error initializing dev mode.", (Exception)e);
        }
        this.util.addShutdownHook(executor);
        try {
            this.util.startServer();
        }
        catch (PluginExecutionException e) {
            throw new MojoExecutionException("Error starting the server in dev mode.", (Exception)((Object)e));
        }
        this.util.runHotkeyReaderThread(executor);
        try {
            this.util.watchFiles(this.outputDirectory, this.testOutputDirectory, executor, this.serverXmlFile, this.bootstrapPropertiesFile, this.jvmOptionsFile);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.getLog().info((CharSequence)e.getMessage());
            }
            return;
        }
    }

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping dev goal.\n");
            return;
        }
        this.doDevMode();
    }

    private void updateParentPoms(Map<String, List<String>> parentPoms, MavenProject proj) {
        MavenProject parentProject = proj.getParent();
        try {
            if (parentProject != null && parentProject.getFile() != null) {
                List<String> childPoms = parentPoms.get(parentProject.getFile().getCanonicalPath());
                if (childPoms == null) {
                    childPoms = new ArrayList<String>();
                    childPoms.add(proj.getFile().getCanonicalPath());
                    parentPoms.put(parentProject.getFile().getCanonicalPath(), childPoms);
                } else if (!childPoms.contains(proj.getFile().getCanonicalPath())) {
                    childPoms.add(proj.getFile().getCanonicalPath());
                }
                if (parentProject.getParent() != null) {
                    this.updateParentPoms(parentPoms, parentProject);
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("An unexpected error occurred when trying to resolve " + proj.getFile() + ": " + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
    }

    private JavaCompilerOptions getMavenCompilerOptions(MavenProject currentProject) {
        String encoding;
        String release;
        String target;
        String source;
        Plugin plugin = this.getPluginForProject("org.apache.maven.plugins", "maven-compiler-plugin", currentProject);
        Xpp3Dom configuration = ExecuteMojoUtil.getPluginGoalConfig(plugin, "compile", this.getLog());
        JavaCompilerOptions compilerOptions = new JavaCompilerOptions();
        String showWarnings = this.getCompilerOption(configuration, "showWarnings", "maven.compiler.showWarnings", currentProject);
        if (showWarnings != null) {
            boolean showWarningsBoolean = Boolean.parseBoolean(showWarnings);
            this.getLog().debug((CharSequence)("Setting showWarnings to " + showWarningsBoolean));
            compilerOptions.setShowWarnings(showWarningsBoolean);
        }
        if ((source = this.getCompilerOption(configuration, "source", "maven.compiler.source", currentProject)) != null) {
            this.getLog().debug((CharSequence)("Setting compiler source to " + source));
            compilerOptions.setSource(source);
        }
        if ((target = this.getCompilerOption(configuration, "target", "maven.compiler.target", currentProject)) != null) {
            this.getLog().debug((CharSequence)("Setting compiler target to " + target));
            compilerOptions.setTarget(target);
        }
        if ((release = this.getCompilerOption(configuration, "release", "maven.compiler.release", currentProject)) != null) {
            this.getLog().debug((CharSequence)("Setting compiler release to " + release));
            compilerOptions.setRelease(release);
        }
        if ((encoding = this.getCompilerOption(configuration, "encoding", "project.build.sourceEncoding", currentProject)) != null) {
            this.getLog().debug((CharSequence)("Setting compiler encoding to " + encoding));
            compilerOptions.setEncoding(encoding);
        }
        return compilerOptions;
    }

    private String getCompilerOption(Xpp3Dom configuration, String mavenParameterName, String projectPropertyName, MavenProject currentProject) {
        Xpp3Dom child;
        String option = null;
        option = this.session.getUserProperties().getProperty(projectPropertyName);
        if (option == null && configuration != null && (child = configuration.getChild(mavenParameterName)) != null) {
            option = child.getValue();
        }
        if (option == null) {
            option = currentProject.getProperties().getProperty(projectPropertyName);
        }
        return option;
    }

    private void processContainerParams() throws MojoExecutionException {
        if (this.container) {
            this.setContainer(true);
        }
    }

    private MavenProject resolveMavenProject(File buildFile) {
        MavenProject currentProject = this.project;
        try {
            ProjectBuildingResult build;
            if (buildFile != null && !this.project.getFile().getCanonicalPath().equals(buildFile.getCanonicalPath()) && (build = this.mavenProjectBuilder.build(buildFile, this.session.getProjectBuildingRequest().setResolveDependencies(true))).getProject() != null) {
                currentProject = build.getProject();
            }
        }
        catch (IOException | ProjectBuildingException e) {
            this.getLog().error((CharSequence)("An unexpected error occurred when trying to run integration tests for " + buildFile.getAbsolutePath() + ": " + e.getMessage()));
            this.getLog().debug(e);
        }
        return currentProject;
    }

    private void runTestMojo(String groupId, String artifactId, String goal, MavenProject project) throws MojoExecutionException {
        Plugin plugin = this.getPluginForProject(groupId, artifactId, project);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.getLog());
        if (this.util.isMultiModuleProject()) {
            try {
                ProjectModule projectModule = this.util.getProjectModule(project.getFile());
                Set testArtifacts = projectModule != null ? projectModule.getTestArtifacts() : this.util.getTestArtifacts();
                if (goal.equals("test") || goal.equals("integration-test")) {
                    this.injectClasspathElements(config, testArtifacts, project.getTestClasspathElements());
                }
            }
            catch (IOException | DependencyResolutionRequiredException e) {
                this.getLog().error((CharSequence)("Unable to resolve test artifact paths for " + project.getFile() + ". Restart dev mode to ensure classpaths are properly resolved."));
                this.getLog().debug(e);
            }
        }
        if (goal.equals("test")) {
            this.injectTestId(config);
        } else if (goal.equals("integration-test")) {
            this.injectTestId(config);
            this.injectLibertyProperties(config);
            File summaryFile = null;
            Xpp3Dom summaryFileElement = config.getChild("summaryFile");
            summaryFile = summaryFileElement != null && summaryFileElement.getValue() != null ? new File(summaryFileElement.getValue()) : new File(project.getBuild().getDirectory(), "failsafe-reports/failsafe-summary.xml");
            try {
                this.getLog().debug((CharSequence)("Looking for summary file at " + summaryFile.getCanonicalPath()));
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Unable to resolve summary file " + e.getMessage()));
            }
            if (summaryFile.exists()) {
                boolean deleteResult = summaryFile.delete();
                this.getLog().debug((CharSequence)("Summary file deleted? " + deleteResult));
            } else {
                this.getLog().debug((CharSequence)"Summary file doesn't exist");
            }
        } else if (goal.equals("failsafe-report-only")) {
            Plugin failsafePlugin = this.getPluginForProject("org.apache.maven.plugins", "maven-failsafe-plugin", project);
            Xpp3Dom failsafeConfig = ExecuteMojoUtil.getPluginGoalConfig(failsafePlugin, "integration-test", this.getLog());
            Xpp3Dom linkXRef = new Xpp3Dom("linkXRef");
            if (failsafeConfig != null) {
                Xpp3Dom reportsDirectoryElement = failsafeConfig.getChild("reportsDirectory");
                if (reportsDirectoryElement != null) {
                    Xpp3Dom reportDirectories = new Xpp3Dom("reportsDirectories");
                    reportDirectories.addChild(reportsDirectoryElement);
                    config.addChild(reportDirectories);
                }
                if ((linkXRef = failsafeConfig.getChild("linkXRef")) == null) {
                    linkXRef = new Xpp3Dom("linkXRef");
                }
            }
            linkXRef.setValue("false");
            config.addChild(linkXRef);
        } else if (goal.equals("report-only")) {
            Plugin surefirePlugin = this.getPluginForProject("org.apache.maven.plugins", "maven-surefire-plugin", project);
            Xpp3Dom surefireConfig = ExecuteMojoUtil.getPluginGoalConfig(surefirePlugin, "test", this.getLog());
            Xpp3Dom linkXRef = new Xpp3Dom("linkXRef");
            if (surefireConfig != null) {
                Xpp3Dom reportsDirectoryElement = surefireConfig.getChild("reportsDirectory");
                if (reportsDirectoryElement != null) {
                    Xpp3Dom reportDirectories = new Xpp3Dom("reportsDirectories");
                    reportDirectories.addChild(reportsDirectoryElement);
                    config.addChild(reportDirectories);
                }
                if ((linkXRef = surefireConfig.getChild("linkXRef")) == null) {
                    linkXRef = new Xpp3Dom("linkXRef");
                }
            }
            linkXRef.setValue("false");
            config.addChild(linkXRef);
        }
        this.getLog().debug((CharSequence)("POM file: " + project.getFile() + "\n" + groupId + ":" + artifactId + " " + goal + " configuration:\n" + config));
        MavenSession tempSession = this.session.clone();
        tempSession.setCurrentProject(project);
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)tempSession, (BuildPluginManager)this.pluginManager));
    }

    private void injectClasspathElements(Xpp3Dom config, Set<String> testArtifacts, List<String> testClasspathElements) {
        if (testArtifacts.size() > testClasspathElements.size()) {
            ArrayList<String> additionalClassPathElements = new ArrayList<String>();
            additionalClassPathElements.addAll(testArtifacts);
            additionalClassPathElements.removeAll(testClasspathElements);
            Xpp3Dom classpathElement = config.getChild("additionalClasspathElements");
            if (classpathElement == null) {
                classpathElement = new Xpp3Dom("additionalClasspathElements");
            }
            for (String element : additionalClassPathElements) {
                Xpp3Dom childElem = new Xpp3Dom("additionalClasspathElement");
                childElem.setValue(element);
                classpathElement.addChild(childElem);
            }
            config.addChild(classpathElement);
        }
    }

    private void injectTestId(Xpp3Dom config) {
        Xpp3Dom properties = config.getChild("properties");
        if (properties == null || properties.getChild(TEST_RUN_ID_PROPERTY_NAME) == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"properties"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)TEST_RUN_ID_PROPERTY_NAME), (String)String.valueOf(this.runId++))});
            config.addChild(e.toDom());
        } else {
            properties.getChild(TEST_RUN_ID_PROPERTY_NAME).setValue(String.valueOf(this.runId++));
        }
    }

    private void injectLibertyProperties(Xpp3Dom config) throws MojoExecutionException {
        Xpp3Dom sysProps = config.getChild("systemPropertyVariables");
        if (sysProps == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"systemPropertyVariables"), (MojoExecutor.Element[])new MojoExecutor.Element[0]);
            sysProps = e.toDom();
            config.addChild(sysProps);
        }
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HOSTNAME, this.util.getHostName());
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HTTP_PORT, this.util.getHttpPort());
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HTTPS_PORT, this.util.getHttpsPort());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HOSTNAME, this.util.getHostName());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HTTP_PORT, this.util.getHttpPort());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HTTPS_PORT, this.util.getHttpsPort());
        try {
            this.addDomPropertyIfNotFound(sysProps, WLP_USER_DIR_PROPERTY_NAME, this.userDirectory.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not resolve canonical path of userDirectory parameter: " + this.userDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    private void addDomPropertyIfNotFound(Xpp3Dom sysProps, String key, String value) {
        if (sysProps.getChild(key) == null && value != null) {
            sysProps.addChild(MojoExecutor.element((String)MojoExecutor.name((String)key), (String)value).toDom());
        }
    }

    private void runBoostMojo(String goal) throws MojoExecutionException {
        MavenProject boostProject = this.project;
        MavenSession boostSession = this.session;
        this.getLog().debug((CharSequence)("plugin version: " + this.boostPlugin.getVersion()));
        MojoExecutor.executeMojo((Plugin)this.boostPlugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)boostProject, (MavenSession)boostSession, (BuildPluginManager)this.pluginManager));
    }

    private void listFiles(File directory, List<File> files, String suffix) {
        File[] fList;
        if (directory != null && (fList = directory.listFiles()) != null) {
            for (File file : fList) {
                if (file.isFile() && (suffix == null || file.getName().toLowerCase().endsWith("." + suffix))) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listFiles(file, files, suffix);
            }
        }
    }

    private void runCompileMojo(String goal, MavenProject mavenProject) throws MojoExecutionException {
        Plugin plugin = this.getPluginForProject("org.apache.maven.plugins", "maven-compiler-plugin", mavenProject);
        MavenSession tempSession = this.session.clone();
        tempSession.setCurrentProject(mavenProject);
        MavenProject tempProject = mavenProject;
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.getLog());
        config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"failOnError"), (String)"false")}), (Xpp3Dom)config);
        this.getLog().info((CharSequence)("Running maven-compiler-plugin:" + goal + " on " + tempProject.getFile()));
        this.getLog().debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)tempProject, (MavenSession)tempSession, (BuildPluginManager)this.pluginManager));
    }

    private void runCompileMojoLogWarning() throws MojoExecutionException {
        this.runCompileMojo("compile", this.project);
        this.updateArtifactPathToOutputDirectory(this.project);
    }

    private void runCompileMojoLogWarning(MavenProject mavenProject) throws MojoExecutionException {
        this.runCompileMojo("compile", mavenProject);
        this.updateArtifactPathToOutputDirectory(mavenProject);
    }

    private void runTestCompileMojoLogWarning() throws MojoExecutionException {
        this.runCompileMojo("testCompile", this.project);
    }

    private void runTestCompileMojoLogWarning(MavenProject mavenProject) throws MojoExecutionException {
        this.runCompileMojo("testCompile", mavenProject);
    }

    @Override
    protected void runLibertyMojoInstallFeature(MojoExecutor.Element features, File serverDir, String containerName) throws MojoExecutionException {
        super.runLibertyMojoInstallFeature(features, serverDir, containerName);
    }

    @Override
    protected void runLibertyMojoCreate() throws MojoExecutionException {
        if (this.container) {
            this.getLog().debug((CharSequence)"runLibertyMojoCreate check for installDirectory and serverDirectory");
            if (!this.installDirectory.isDirectory()) {
                this.installDirectory.mkdirs();
            }
            if (!this.serverDirectory.isDirectory()) {
                this.serverDirectory.mkdirs();
            }
        } else {
            super.runLibertyMojoCreate();
        }
    }

    @Override
    protected void runLibertyMojoGenerateFeatures(MojoExecutor.Element classFiles, boolean optimize) throws MojoExecutionException {
        super.runLibertyMojoGenerateFeatures(classFiles, optimize);
    }

    private class DevMojoUtil
    extends DevUtil {
        Set<String> existingFeatures;
        Map<String, File> libertyDirPropertyFiles;
        List<MavenProject> upstreamMavenProjects;
        private static final String LIBERTY_BOOTSTRAP_PROP = "liberty.bootstrap.";
        private static final String LIBERTY_JVM_PROP = "liberty.jvm.";
        private static final String LIBERTY_ENV_PROP = "liberty.env.";
        private static final String LIBERTY_VAR_PROP = "liberty.var.";
        private static final String LIBERTY_DEFAULT_VAR_PROP = "liberty.defaultVar.";

        public DevMojoUtil(File installDir, File userDir, File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, File projectDirectory, File multiModuleProjectDirectory, List<File> resourceDirs, JavaCompilerOptions compilerOptions, String mavenCacheLocation, List<ProjectModule> upstreamProjects, List<MavenProject> upstreamMavenProjects, boolean recompileDeps, File pom, Map<String, List<String>> parentPoms, boolean generateFeatures, Set<String> compileArtifactPaths, Set<String> testArtifactPaths, List<Path> webResourceDirs) throws IOException {
            super(new File(DevMojo.this.project.getBuild().getDirectory()), serverDirectory, sourceDirectory, testSourceDirectory, configDirectory, projectDirectory, multiModuleProjectDirectory, resourceDirs, DevMojo.this.hotTests, DevMojo.this.skipTests, DevMojo.this.skipUTs, DevMojo.this.skipITs, DevMojo.this.project.getArtifactId(), (long)DevMojo.this.serverStartTimeout, DevMojo.this.verifyTimeout, DevMojo.this.verifyTimeout, (long)(DevMojo.this.compileWait * 1000.0), DevMojo.this.libertyDebug, false, false, DevMojo.this.pollingTest, DevMojo.this.container, DevMojo.this.dockerfile, DevMojo.this.dockerBuildContext, DevMojo.this.dockerRunOpts, DevMojo.this.dockerBuildTimeout, DevMojo.this.skipDefaultPorts, compilerOptions, DevMojo.this.keepTempDockerfile, mavenCacheLocation, upstreamProjects, recompileDeps, DevMojo.this.project.getPackaging(), pom, parentPoms, generateFeatures, compileArtifactPaths, testArtifactPaths, webResourceDirs);
            this.libertyDirPropertyFiles = new HashMap<String, File>();
            this.libertyDirPropertyFiles = BasicSupport.getLibertyDirectoryPropertyFiles(installDir, userDir, serverDirectory);
            ServerFeatureUtil servUtil = DevMojo.this.getServerFeatureUtil(true, this.libertyDirPropertyFiles);
            this.existingFeatures = servUtil.getServerFeatures(serverDirectory, this.libertyDirPropertyFiles);
            this.upstreamMavenProjects = upstreamMavenProjects;
        }

        public void debug(String msg) {
            DevMojo.this.getLog().debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.getLog().debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.getLog().debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.getLog().warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.getLog().info((CharSequence)msg);
        }

        public void error(String msg) {
            DevMojo.this.getLog().error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            DevMojo.this.getLog().error((CharSequence)msg, e);
        }

        public boolean isDebugEnabled() {
            return DevMojo.this.getLog().isDebugEnabled();
        }

        public String getServerStartTimeoutExample() {
            return "'mvn liberty:dev -DserverStartTimeout=120'";
        }

        public String getProjectName() {
            return DevMojo.this.project.getArtifactId();
        }

        public void libertyCreate() throws PluginExecutionException {
            try {
                if (DevMojo.this.isUsingBoost()) {
                    DevMojo.this.getLog().info((CharSequence)"Running boost:package");
                    DevMojo.this.runBoostMojo("package");
                } else {
                    DevMojo.this.runLibertyMojoCreate();
                }
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public boolean libertyGenerateFeatures(Collection<String> classes, boolean optimize) {
            try {
                if (classes != null) {
                    MojoExecutor.Element[] classesElem = new MojoExecutor.Element[classes.size()];
                    int i = 0;
                    for (String classPath : classes) {
                        classesElem[i] = MojoExecutor.element((String)MojoExecutor.name((String)"classFile"), (String)classPath);
                        ++i;
                    }
                    DevMojo.this.runLibertyMojoGenerateFeatures(MojoExecutor.element((String)MojoExecutor.name((String)"classFiles"), (MojoExecutor.Element[])classesElem), optimize);
                } else {
                    DevMojo.this.runLibertyMojoGenerateFeatures(null, optimize);
                }
                return true;
            }
            catch (MojoExecutionException e) {
                if (e.getCause() != null && e.getCause() instanceof PluginExecutionException) {
                    DevMojo.this.getLog().error((CharSequence)(e.getMessage() + ".\nDisabling the automatic generation of features."));
                    this.setFeatureGeneration(false);
                } else {
                    DevMojo.this.getLog().error((CharSequence)(e.getMessage() + "\nTo disable the automatic generation of features, type 'g' and press Enter."));
                }
                return false;
            }
        }

        public void libertyInstallFeature() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoInstallFeature(null, null, DevMojo.this.container ? super.getContainerName() : null);
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public void libertyDeploy() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoDeploy();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public void stopServer() {
            this.serverFullyStarted.set(false);
            if (DevMojo.this.container) {
                return;
            }
            try {
                ServerTask serverTask = DevMojo.this.initializeJava();
                serverTask.setOperation("stop");
                serverTask.execute();
            }
            catch (Exception e) {
                DevMojo.this.getLog().warn((CharSequence)MessageFormat.format(messages.getString("warn.server.stopped"), DevMojo.this.serverName));
            }
        }

        public ServerTask getServerTask() throws Exception {
            if (DevMojo.this.serverTask != null) {
                return DevMojo.this.serverTask;
            }
            DevMojo.this.serverTask = DevMojo.this.initializeJava();
            DevMojo.this.copyConfigFiles();
            DevMojo.this.serverTask.setClean(DevMojo.this.clean);
            if (DevMojo.this.libertyDebug) {
                this.setLibertyDebugPort(DevMojo.this.libertyDebugPort);
                DevMojo.this.serverTask.setOperation("debug");
                DevMojo.this.serverTask.setEnvironmentVariables(this.getDebugEnvironmentVariables());
            } else {
                DevMojo.this.serverTask.setOperation("run");
            }
            return DevMojo.this.serverTask;
        }

        private Properties getPropertiesWithKeyPrefix(Properties p, String prefix) {
            Properties result = new Properties();
            if (p != null) {
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith(prefix)) continue;
                    result.put(key, p.get(key));
                }
            }
            return result;
        }

        private List<Dependency> getEsaDependency(List<Dependency> dependencies) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    if (!"esa".equals(d.getType())) continue;
                    deps.add(d);
                }
            }
            return deps;
        }

        private List<Dependency> getCompileDependency(List<Dependency> dependencies) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    if (!"compile".equals(d.getScope()) && !"provided".equals(d.getScope())) continue;
                    deps.add(d);
                }
            }
            return deps;
        }

        private boolean dependencyListsEquals(List<Dependency> oldDeps, List<Dependency> deps) {
            if (oldDeps.size() != deps.size()) {
                return false;
            }
            for (int i = 0; i < oldDeps.size(); ++i) {
                if (this.dependencyEquals(oldDeps.get(i), deps.get(i))) continue;
                return false;
            }
            return true;
        }

        private boolean dependencyEquals(Dependency dep1, Dependency dep2) {
            if (!dep1.toString().equals(dep2.toString())) {
                return false;
            }
            return dep1.getScope().equals(dep2.getScope());
        }

        private boolean hasServerPropertyChanged(MavenProject project, MavenProject backupProject) {
            Properties projProp = project.getProperties();
            Properties backupProjProp = backupProject.getProperties();
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_BOOTSTRAP_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_BOOTSTRAP_PROP))) {
                return true;
            }
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_JVM_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_JVM_PROP))) {
                return true;
            }
            return !Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_ENV_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_ENV_PROP));
        }

        private boolean hasServerVariableChanged(MavenProject project, MavenProject backupProject) {
            Properties projProp = project.getProperties();
            Properties backupProjProp = backupProject.getProperties();
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_VAR_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_VAR_PROP))) {
                return true;
            }
            return !Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_DEFAULT_VAR_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_DEFAULT_VAR_PROP));
        }

        private boolean restartForLibertyMojoConfigChanged(Xpp3Dom config, Xpp3Dom oldConfig) {
            if (!Objects.equals(config.getChild("bootstrapProperties"), oldConfig.getChild("bootstrapProperties"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("bootstrapPropertiesFile"), oldConfig.getChild("bootstrapPropertiesFile"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("jvmOptions"), oldConfig.getChild("jvmOptions"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("jvmOptionsFile"), oldConfig.getChild("jvmOptionsFile"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("serverEnv"), oldConfig.getChild("serverEnv"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("serverEnvFile"), oldConfig.getChild("serverEnvFile"))) {
                return true;
            }
            return !Objects.equals(config.getChild("configDirectory"), oldConfig.getChild("configDirectory"));
        }

        public boolean updateArtifactPaths(ProjectModule projectModule, boolean redeployCheck, boolean generateFeatures, ThreadPoolExecutor executor) throws PluginExecutionException {
            try {
                MavenProject upstreamProject;
                File buildFile = projectModule.getBuildFile();
                if (buildFile == null) {
                    buildFile = this.buildFile;
                }
                MavenProject backupUpstreamProject = upstreamProject = this.getMavenProject(buildFile);
                for (MavenProject p : this.upstreamMavenProjects) {
                    if (buildFile == null || !p.getFile().getCanonicalPath().equals(buildFile.getCanonicalPath())) continue;
                    backupUpstreamProject = p;
                }
                JavaCompilerOptions oldCompilerOptions = DevMojo.this.getMavenCompilerOptions(backupUpstreamProject);
                JavaCompilerOptions compilerOptions = DevMojo.this.getMavenCompilerOptions(upstreamProject);
                if (!oldCompilerOptions.getOptions().equals(compilerOptions.getOptions())) {
                    DevMojo.this.getLog().debug((CharSequence)("Maven compiler options have been modified: " + compilerOptions.getOptions()));
                    DevMojo.this.util.getProjectModule(buildFile).setCompilerOptions(compilerOptions);
                }
                Set testArtifactPaths = projectModule.getTestArtifacts();
                Set compileArtifactPaths = projectModule.getCompileArtifacts();
                if (this.parentBuildFiles.isEmpty()) {
                    compileArtifactPaths.clear();
                    testArtifactPaths.clear();
                } else {
                    testArtifactPaths.removeAll(backupUpstreamProject.getTestClasspathElements());
                    compileArtifactPaths.removeAll(backupUpstreamProject.getCompileClasspathElements());
                }
                testArtifactPaths.addAll(upstreamProject.getTestClasspathElements());
                compileArtifactPaths.addAll(upstreamProject.getCompileClasspathElements());
                if (!this.parentBuildFiles.isEmpty() && this.parentBuildFiles.containsKey(projectModule.getBuildFile().getCanonicalPath())) {
                    this.updateArtifactPaths(projectModule.getBuildFile());
                }
                if (redeployCheck) {
                    int index = this.upstreamMavenProjects.indexOf(backupUpstreamProject);
                    this.upstreamMavenProjects.set(index, upstreamProject);
                    List deps = upstreamProject.getDependencies();
                    List oldDeps = backupUpstreamProject.getDependencies();
                    if (!this.dependencyListsEquals(this.getCompileDependency(deps), this.getCompileDependency(oldDeps))) {
                        if (generateFeatures) {
                            DevMojo.this.getLog().debug((CharSequence)("Detected a change in the compile dependencies for " + buildFile + " , regenerating features"));
                            boolean generateFeaturesSuccess = this.libertyGenerateFeatures(null, true);
                            if (generateFeaturesSuccess) {
                                DevMojo.this.util.getJavaSourceClassPaths().clear();
                            }
                            DevMojo.this.util.installFeaturesToTempDir(this.generatedFeaturesFile, DevMojo.this.configDirectory, null, generateFeaturesSuccess);
                        }
                        DevMojo.this.runLibertyMojoDeploy();
                    }
                }
            }
            catch (IOException | DependencyResolutionRequiredException | MojoExecutionException | ProjectBuildingException e) {
                DevMojo.this.getLog().error((CharSequence)("An unexpected error occurred while processing changes in " + this.buildFile.getAbsolutePath() + ": " + e.getMessage()));
                DevMojo.this.getLog().debug(e);
                return false;
            }
            return true;
        }

        public boolean updateArtifactPaths(File buildFile) {
            try {
                MavenProject parentProject = this.getMavenProject(buildFile);
                this.updateChildProjectArtifactPaths(buildFile, parentProject.getCompileClasspathElements(), parentProject.getTestClasspathElements());
            }
            catch (IOException | DependencyResolutionRequiredException | ProjectBuildingException e) {
                DevMojo.this.getLog().error((CharSequence)("An unexpected error occurred while processing changes in " + buildFile.getAbsolutePath() + ": " + e.getMessage()));
                DevMojo.this.getLog().debug(e);
                return false;
            }
            return true;
        }

        private void updateChildProjectArtifactPaths(File parentBuildFile, List<String> compileClasspathElements, List<String> testClasspathElements) throws IOException, ProjectBuildingException, DependencyResolutionRequiredException {
            List childBuildFiles = (List)this.parentBuildFiles.get(parentBuildFile.getCanonicalPath());
            if (childBuildFiles != null) {
                for (String childBuildPath : childBuildFiles) {
                    if (this.parentBuildFiles.containsKey(childBuildPath)) {
                        MavenProject project = this.getMavenProject(new File(childBuildPath));
                        if (project != null) {
                            compileClasspathElements.addAll(project.getCompileClasspathElements());
                            testClasspathElements.addAll(project.getTestClasspathElements());
                        }
                        this.updateChildProjectArtifactPaths(new File(childBuildPath), compileClasspathElements, testClasspathElements);
                        continue;
                    }
                    Set compileArtifacts = null;
                    Set testArtifacts = null;
                    MavenProject project = null;
                    if (childBuildPath.equals(this.buildFile.getCanonicalPath())) {
                        compileArtifacts = DevMojo.this.util.getCompileArtifacts();
                        testArtifacts = DevMojo.this.util.getTestArtifacts();
                        project = this.getMavenProject(this.buildFile);
                    } else if (this.getProjectModule(new File(childBuildPath)) != null) {
                        ProjectModule projectModule = this.getProjectModule(new File(childBuildPath));
                        compileArtifacts = projectModule.getCompileArtifacts();
                        testArtifacts = projectModule.getTestArtifacts();
                        project = this.getMavenProject(projectModule.getBuildFile());
                    }
                    if (compileArtifacts == null || testArtifacts == null || project == null) continue;
                    compileArtifacts.clear();
                    testArtifacts.clear();
                    compileClasspathElements.addAll(project.getCompileClasspathElements());
                    testClasspathElements.addAll(project.getTestClasspathElements());
                    compileArtifacts.addAll(compileClasspathElements);
                    testArtifacts.addAll(testClasspathElements);
                }
            }
        }

        private MavenProject getMavenProject(File buildFile) throws ProjectBuildingException {
            ProjectBuildingResult build = DevMojo.this.mavenProjectBuilder.build(buildFile, DevMojo.this.session.getProjectBuildingRequest().setResolveDependencies(true));
            MavenProject builtProject = build.getProject();
            this.updateUpstreamProjectsArtifactPathToOutputDirectory(builtProject);
            return builtProject;
        }

        private void updateUpstreamProjectsArtifactPathToOutputDirectory(MavenProject startingProject) {
            Map artifactMap = startingProject.getArtifactMap();
            for (MavenProject p : this.upstreamMavenProjects) {
                Artifact projArtifact = (Artifact)artifactMap.get(p.getGroupId() + ":" + p.getArtifactId());
                if (projArtifact == null) continue;
                DevMojo.this.updateArtifactPathToOutputDirectory(p, projArtifact);
            }
        }

        protected void updateLooseApp() throws PluginExecutionException {
            if (DevMojo.this.project.getPackaging().equals("war")) {
                if (LooseWarApplication.isExploded(DevMojo.this.project)) {
                    if (!DevMojo.this.isExplodedLooseWarApp) {
                        DevMojo.this.isExplodedLooseWarApp = true;
                        Plugin warPlugin = DevMojo.this.getPlugin("org.apache.maven.plugins", "maven-war-plugin");
                        if (!DevMojo.this.validatePluginVersion(warPlugin.getVersion(), "3.3.1")) {
                            DevMojo.this.getLog().warn((CharSequence)"Exploded WAR functionality is enabled. Please use maven-war-plugin version 3.3.1 or greater for best results.");
                        }
                        this.redeployApp();
                    } else {
                        try {
                            DevMojo.this.runExplodedMojo();
                        }
                        catch (MojoExecutionException e) {
                            DevMojo.this.getLog().error((CharSequence)"Failed to run war:exploded goal", (Throwable)e);
                        }
                    }
                } else if (DevMojo.this.isExplodedLooseWarApp) {
                    DevMojo.this.isExplodedLooseWarApp = false;
                    this.redeployApp();
                }
            }
        }

        protected void resourceDirectoryCreated() throws IOException {
            if (DevMojo.this.project.getPackaging().equals("war") && LooseWarApplication.isExploded(DevMojo.this.project)) {
                try {
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                    DevMojo.this.runExplodedMojo();
                }
                catch (MojoExecutionException e) {
                    DevMojo.this.getLog().error((CharSequence)"Failed to run goal(s)", (Throwable)e);
                }
            }
        }

        protected void resourceModifiedOrCreated(File fileChanged, File resourceParent, File outputDirectory) throws IOException {
            if (DevMojo.this.project.getPackaging().equals("war") && LooseWarApplication.isExploded(DevMojo.this.project)) {
                try {
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                    DevMojo.this.runExplodedMojo();
                }
                catch (MojoExecutionException e) {
                    DevMojo.this.getLog().error((CharSequence)"Failed to run goal(s)", (Throwable)e);
                }
            } else {
                this.copyFile(fileChanged, resourceParent, outputDirectory, null);
            }
        }

        protected void resourceDeleted(File fileChanged, File resourceParent, File outputDirectory) throws IOException {
            this.deleteFile(fileChanged, resourceParent, outputDirectory, null);
            if (DevMojo.this.project.getPackaging().equals("war") && LooseWarApplication.isExploded(DevMojo.this.project)) {
                try {
                    DevMojo.this.runExplodedMojo();
                }
                catch (MojoExecutionException e) {
                    DevMojo.this.getLog().error((CharSequence)"Failed to run goal(s)", (Throwable)e);
                }
            }
        }

        public boolean recompileBuildFile(File buildFile, Set<String> compileArtifactPaths, Set<String> testArtifactPaths, boolean generateFeatures, ThreadPoolExecutor executor) throws PluginExecutionException {
            ProjectBuildingResult build;
            boolean restartServer = false;
            boolean createServer = false;
            boolean installFeature = false;
            boolean redeployApp = false;
            boolean runBoostPackage = false;
            boolean optimizeGenerateFeatures = false;
            try {
                build = DevMojo.this.mavenProjectBuilder.build(buildFile, DevMojo.this.session.getProjectBuildingRequest().setResolveDependencies(true));
            }
            catch (ProjectBuildingException e) {
                DevMojo.this.getLog().error((CharSequence)("Could not parse pom.xml. " + e.getMessage()));
                DevMojo.this.getLog().debug((Throwable)e);
                return false;
            }
            Plugin backupLibertyPlugin = DevMojo.this.getLibertyPlugin();
            MavenProject backupProject = DevMojo.this.project;
            DevMojo.this.project = build.getProject();
            DevMojo.this.session.setCurrentProject(DevMojo.this.project);
            Plugin libertyPlugin = DevMojo.this.getLibertyPlugin();
            try {
                Xpp3Dom oldConfig;
                Xpp3Dom config;
                JavaCompilerOptions oldCompilerOptions = DevMojo.this.getMavenCompilerOptions(backupProject);
                JavaCompilerOptions compilerOptions = DevMojo.this.getMavenCompilerOptions(DevMojo.this.project);
                if (!oldCompilerOptions.getOptions().equals(compilerOptions.getOptions())) {
                    DevMojo.this.getLog().debug((CharSequence)("Maven compiler options have been modified: " + compilerOptions.getOptions()));
                    DevMojo.this.util.updateJavaCompilerOptions(compilerOptions);
                }
                if (this.hasServerPropertyChanged(DevMojo.this.project, backupProject)) {
                    restartServer = true;
                }
                if (!restartServer && this.hasServerVariableChanged(DevMojo.this.project, backupProject)) {
                    createServer = true;
                }
                if (!restartServer && !Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "create", DevMojo.this.getLog()), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "create", DevMojo.this.getLog()))) {
                    createServer = true;
                    if (this.restartForLibertyMojoConfigChanged(config, oldConfig)) {
                        restartServer = true;
                    }
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "install-feature", DevMojo.this.getLog()), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "install-feature", DevMojo.this.getLog()))) {
                    installFeature = true;
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "deploy", DevMojo.this.getLog()), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "deploy", DevMojo.this.getLog()))) {
                    redeployApp = true;
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "generate-features", DevMojo.this.getLog()), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "generate-features", DevMojo.this.getLog()))) {
                    optimizeGenerateFeatures = true;
                }
                List deps = DevMojo.this.project.getDependencies();
                List oldDeps = backupProject.getDependencies();
                if (!this.dependencyListsEquals(oldDeps, deps)) {
                    runBoostPackage = true;
                    if (!this.dependencyListsEquals(this.getEsaDependency(deps), this.getEsaDependency(oldDeps))) {
                        installFeature = true;
                    }
                    if (!this.dependencyListsEquals(this.getCompileDependency(deps), this.getCompileDependency(oldDeps))) {
                        redeployApp = true;
                        optimizeGenerateFeatures = true;
                    }
                }
                if (this.parentBuildFiles.isEmpty()) {
                    compileArtifactPaths.clear();
                    testArtifactPaths.clear();
                } else {
                    testArtifactPaths.removeAll(backupProject.getTestClasspathElements());
                    compileArtifactPaths.removeAll(backupProject.getCompileClasspathElements());
                }
                compileArtifactPaths.addAll(DevMojo.this.project.getCompileClasspathElements());
                testArtifactPaths.addAll(DevMojo.this.project.getTestClasspathElements());
                boolean generateFeaturesSuccess = false;
                if (optimizeGenerateFeatures && generateFeatures) {
                    DevMojo.this.getLog().debug((CharSequence)"Detected a change in the compile dependencies, regenerating features");
                    generateFeaturesSuccess = this.libertyGenerateFeatures(null, true);
                    if (generateFeaturesSuccess) {
                        DevMojo.this.util.getJavaSourceClassPaths().clear();
                    } else {
                        installFeature = false;
                    }
                }
                if (restartServer) {
                    DevMojo.this.util.restartServer();
                    return true;
                }
                if (DevMojo.this.isUsingBoost() && (createServer || runBoostPackage)) {
                    DevMojo.this.getLog().info((CharSequence)"Running boost:package");
                    DevMojo.this.runBoostMojo("package");
                } else if (createServer) {
                    DevMojo.this.runLibertyMojoCreate();
                } else if (redeployApp) {
                    DevMojo.this.util.installFeaturesToTempDir(this.generatedFeaturesFile, DevMojo.this.configDirectory, null, generateFeaturesSuccess);
                    DevMojo.this.runLibertyMojoDeploy();
                }
                if (installFeature) {
                    DevMojo.this.runLibertyMojoInstallFeature(null, null, super.getContainerName());
                }
                if (!(restartServer || createServer || redeployApp || installFeature || runBoostPackage)) {
                    DevMojo.this.getLog().debug((CharSequence)"changes in the pom.xml are not monitored by dev mode");
                    return true;
                }
            }
            catch (IOException | DependencyResolutionRequiredException | MojoExecutionException e) {
                DevMojo.this.getLog().error((CharSequence)("An unexpected error occurred while processing changes in pom.xml. " + e.getMessage()));
                if (installFeature) {
                    this.libertyDependencyWarning(generateFeatures, (Exception)e);
                }
                DevMojo.this.getLog().debug(e);
                DevMojo.this.project = backupProject;
                DevMojo.this.session.setCurrentProject(backupProject);
                return false;
            }
            return true;
        }

        private void libertyDependencyWarning(boolean generateFeatures, Exception e) {
            if (generateFeatures && !this.getEsaDependency(DevMojo.this.project.getDependencies()).isEmpty() && e.getMessage().contains("A feature conflict error occurred while installing features: ")) {
                DevMojo.this.getLog().warn((CharSequence)DevMojo.GEN_FEAT_LIBERTY_DEP_WARNING);
            }
        }

        public void installFeatures(File configFile, File serverDir, boolean generateFeatures) {
            try {
                ServerFeatureUtil servUtil = DevMojo.this.getServerFeatureUtil(true, this.libertyDirPropertyFiles);
                Set features = servUtil.getServerFeatures(serverDir, this.libertyDirPropertyFiles);
                if (features != null) {
                    HashSet featuresCopy = new HashSet(features);
                    if (this.existingFeatures != null) {
                        features.removeAll(this.existingFeatures);
                        HashSet<String> existingFeaturesCopy = new HashSet<String>(this.existingFeatures);
                        existingFeaturesCopy.removeAll(featuresCopy);
                        if (!existingFeaturesCopy.isEmpty()) {
                            DevMojo.this.getLog().info((CharSequence)("Configuration features have been removed: " + existingFeaturesCopy));
                        }
                    }
                    if (!features.isEmpty()) {
                        DevMojo.this.getLog().info((CharSequence)("Configuration features have been added: " + features));
                        MojoExecutor.Element[] featureElems = new MojoExecutor.Element[features.size() + 1];
                        featureElems[0] = MojoExecutor.element((String)MojoExecutor.name((String)"acceptLicense"), (String)"true");
                        String[] values = features.toArray(new String[features.size()]);
                        for (int i = 0; i < features.size(); ++i) {
                            featureElems[i + 1] = MojoExecutor.element((String)MojoExecutor.name((String)"feature"), (String)values[i]);
                        }
                        DevMojo.this.runLibertyMojoInstallFeature(MojoExecutor.element((String)MojoExecutor.name((String)"features"), (MojoExecutor.Element[])featureElems), serverDir, super.getContainerName());
                    }
                }
            }
            catch (MojoExecutionException e) {
                DevMojo.this.getLog().error((CharSequence)"Failed to install features from configuration file", (Throwable)e);
                this.libertyDependencyWarning(generateFeatures, (Exception)((Object)e));
            }
        }

        public ServerFeatureUtil getServerFeatureUtilObj() {
            return DevMojo.this.getServerFeatureUtil(true, this.libertyDirPropertyFiles);
        }

        public Set<String> getExistingFeatures() {
            return this.existingFeatures;
        }

        public void updateExistingFeatures() {
            Set features;
            ServerFeatureUtil servUtil = DevMojo.this.getServerFeatureUtil(true, this.libertyDirPropertyFiles);
            this.existingFeatures = features = servUtil.getServerFeatures(DevMojo.this.serverDirectory, this.libertyDirPropertyFiles);
        }

        public boolean compile(File dir) {
            try {
                if (dir.equals(DevMojo.this.sourceDirectory)) {
                    DevMojo.this.runCompileMojoLogWarning();
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                }
                if (dir.equals(DevMojo.this.testSourceDirectory)) {
                    DevMojo.this.runTestCompileMojoLogWarning();
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "testResources");
                }
                return true;
            }
            catch (MojoExecutionException e) {
                DevMojo.this.getLog().error((CharSequence)"Unable to compile", (Throwable)e);
                return false;
            }
        }

        public boolean compile(File dir, ProjectModule project) {
            MavenProject mavenProject = DevMojo.this.resolveMavenProject(project.getBuildFile());
            try {
                if (dir.equals(project.getSourceDirectory())) {
                    DevMojo.this.runCompileMojoLogWarning(mavenProject);
                    DevMojo.this.runMojoForProject("org.apache.maven.plugins", "maven-resources-plugin", "resources", mavenProject);
                }
                if (dir.equals(project.getTestSourceDirectory())) {
                    DevMojo.this.runTestCompileMojoLogWarning(mavenProject);
                    DevMojo.this.runMojoForProject("org.apache.maven.plugins", "maven-resources-plugin", "testResources", mavenProject);
                }
                return true;
            }
            catch (MojoExecutionException e) {
                DevMojo.this.getLog().error((CharSequence)"Unable to compile", (Throwable)e);
                return false;
            }
        }

        public void runUnitTests(File buildFile) throws PluginExecutionException, PluginScenarioException {
            MavenProject currentProject = DevMojo.this.resolveMavenProject(buildFile);
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-plugin", "test", currentProject);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-report-plugin", "report-only", currentProject);
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Unit tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run unit tests", (Throwable)e);
            }
        }

        public void runIntegrationTests(File buildFile) throws PluginExecutionException, PluginScenarioException {
            MavenProject currentProject = DevMojo.this.resolveMavenProject(buildFile);
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test", currentProject);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-report-plugin", "failsafe-report-only", currentProject);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "verify", currentProject);
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Integration tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run integration tests", (Throwable)e);
            }
        }

        public void redeployApp() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoDeploy();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException("liberty:deploy goal failed:" + e.getMessage());
            }
        }

        public boolean isLooseApplication() {
            return DeployMojoSupport.isSupportedLooseAppType(DevMojo.this.project.getPackaging());
        }

        public File getLooseApplicationFile() {
            return DevMojo.this.getLooseAppConfigFile(DevMojo.this.project, DevMojo.this.container);
        }
    }
}

