/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.openlineage.client.metrics.CompositeMeterRegistryFactory;
import io.openlineage.client.metrics.MeterRegistryFactory;
import io.openlineage.client.metrics.SimpleMeterRegistryFactory;
import io.openlineage.client.metrics.StatsDMeterRegistryFactory;
import io.openlineage.client.utils.ReflectionUtils;
import io.openlineage.spark.shaded.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MicrometerProvider {
    private static final List<MeterRegistryFactory> factories;
    private static CompositeMeterRegistry registry;

    public static Optional<MeterRegistry> parseMeterRegistryConfig(Map<String, Object> config) {
        if (config == null) {
            return Optional.empty();
        }
        Object type = config.get("type");
        if (!(type instanceof String) || type == null || StringUtils.isEmpty((String)type)) {
            return Optional.empty();
        }
        return MicrometerProvider.getConfigBuilder((String)type).map(x -> x.registry(config));
    }

    public static MeterRegistry addMeterRegistryFromConfig(Map<String, Object> config) {
        Optional<MeterRegistry> meterRegistry = MicrometerProvider.parseMeterRegistryConfig(config);
        meterRegistry.ifPresent(x -> registry.add((MeterRegistry)x));
        return registry;
    }

    public static MeterRegistry addMeterRegistry(MeterRegistry meterRegistry) {
        registry.add(meterRegistry);
        return registry;
    }

    public static MeterRegistry getMeterRegistry() {
        return registry;
    }

    public static MeterRegistry clear() {
        registry.close();
        registry = new CompositeMeterRegistry();
        return registry;
    }

    private static List<MeterRegistryFactory> getMetricsBuilders() {
        ArrayList<MeterRegistryFactory> builders = new ArrayList<MeterRegistryFactory>();
        if (ReflectionUtils.hasClass("io.micrometer.statsd.StatsdMeterRegistry")) {
            builders.add(new StatsDMeterRegistryFactory());
        }
        builders.add(new SimpleMeterRegistryFactory());
        builders.add(new CompositeMeterRegistryFactory());
        return builders;
    }

    private static Optional<MeterRegistryFactory> getConfigBuilder(String type) {
        return factories.stream().filter(builder -> builder.type().equals(type)).findFirst();
    }

    static {
        ServiceLoader<MeterRegistryFactory> loader = ServiceLoader.load(MeterRegistryFactory.class);
        factories = Stream.concat(MicrometerProvider.getMetricsBuilders().stream(), StreamSupport.stream(loader.spliterator(), false)).collect(Collectors.toList());
        registry = new CompositeMeterRegistry();
    }
}

