/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import lombok.NonNull;

public abstract class Transport {
    Transport(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public abstract void emit(@NonNull OpenLineage.RunEvent var1);

    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(datasetEvent));
    }

    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(jobEvent));
    }

    @Deprecated
    public void emit(String eventAsJson) {
        throw new UnsupportedOperationException("Please implement emit(OpenLineage.DatasetEvent) and emit(OpenLineage.JobEvent)");
    }

    public Transport() {
    }

    static enum Type {
        CONSOLE,
        FILE,
        HTTP,
        KAFKA,
        KINESIS,
        NOOP;

    }
}

