/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils;

import java.util.LinkedList;
import java.util.List;

public final class DatasetIdentifier {
    private final String name;
    private final String namespace;
    private final List<Symlink> symlinks;

    public DatasetIdentifier(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
        this.symlinks = new LinkedList<Symlink>();
    }

    public DatasetIdentifier withSymlink(String name, String namespace, SymlinkType type) {
        this.symlinks.add(new Symlink(name, namespace, type));
        return this;
    }

    public DatasetIdentifier withSymlink(Symlink symlink) {
        this.symlinks.add(symlink);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<Symlink> getSymlinks() {
        return this.symlinks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasetIdentifier)) {
            return false;
        }
        DatasetIdentifier other = (DatasetIdentifier)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        List<Symlink> this$symlinks = this.getSymlinks();
        List<Symlink> other$symlinks = other.getSymlinks();
        return !(this$symlinks == null ? other$symlinks != null : !((Object)this$symlinks).equals(other$symlinks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        List<Symlink> $symlinks = this.getSymlinks();
        result = result * 59 + ($symlinks == null ? 43 : ((Object)$symlinks).hashCode());
        return result;
    }

    public String toString() {
        return "DatasetIdentifier(name=" + this.getName() + ", namespace=" + this.getNamespace() + ", symlinks=" + this.getSymlinks() + ")";
    }

    public static final class Symlink {
        private final String name;
        private final String namespace;
        private final SymlinkType type;

        public Symlink(String name, String namespace, SymlinkType type) {
            this.name = name;
            this.namespace = namespace;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public SymlinkType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Symlink)) {
                return false;
            }
            Symlink other = (Symlink)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            SymlinkType this$type = this.getType();
            SymlinkType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            SymlinkType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "DatasetIdentifier.Symlink(name=" + this.getName() + ", namespace=" + this.getNamespace() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static enum SymlinkType {
        TABLE;

    }
}

