/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils;

import io.openlineage.spark.shaded.org.apache.commons.lang3.ArrayUtils;
import io.openlineage.spark.shaded.org.apache.commons.lang3.ClassUtils;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Optional<Object> tryExecuteStaticMethodForClassName(String className, String methodName, Object ... args) {
        Class<?> clazz;
        try {
            clazz = ClassUtils.getClass(className);
        }
        catch (ClassNotFoundException | Error e) {
            log.debug("Can't get class {}", (Object)className, (Object)e);
            return Optional.empty();
        }
        args = ArrayUtils.nullToEmpty(args);
        Class[] parameterTypes = ClassUtils.toClass(args);
        try {
            return Optional.of(MethodUtils.invokeStaticMethod(clazz, (String)methodName, (Object[])args, (Class[])parameterTypes));
        }
        catch (Error | Exception e) {
            log.debug("Can't execute static method {}.{}:", new Object[]{className, methodName, e});
            return Optional.empty();
        }
    }

    public static Optional<Object> tryExecuteMethod(Object object, String methodName, Object ... args) {
        try {
            return Optional.of(MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])args));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static boolean hasClass(String aClass) {
        try {
            ReflectionUtils.class.getClassLoader().loadClass(aClass);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasClasses(String ... classes) {
        return Arrays.stream(classes).allMatch(ReflectionUtils::hasClass);
    }
}

