/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent;

import io.openlineage.client.DefaultConfigPathProvider;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.ConsoleConfig;
import io.openlineage.spark.agent.UrlParser;
import io.openlineage.spark.agent.util.SparkConfUtils;
import io.openlineage.spark.api.SparkOpenLineageConfig;
import io.openlineage.spark.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import io.openlineage.spark.shaded.org.apache.commons.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class ArgumentParser {
    private static final Logger log = LoggerFactory.getLogger(ArgumentParser.class);
    public static final String SPARK_CONF_NAMESPACE = "spark.openlineage.namespace";
    public static final String SPARK_CONF_PARENT_JOB_NAMESPACE = "spark.openlineage.parentJobNamespace";
    public static final String SPARK_CONF_PARENT_JOB_NAME = "spark.openlineage.parentJobName";
    public static final String SPARK_CONF_PARENT_RUN_ID = "spark.openlineage.parentRunId";
    public static final String SPARK_CONF_APP_NAME = "spark.openlineage.appName";
    public static final String ARRAY_PREFIX_CHAR = "[";
    public static final String ARRAY_SUFFIX_CHAR = "]";
    public static final String DISABLED_FACETS_SEPARATOR = ";";
    public static final String SPARK_CONF_TRANSPORT_TYPE = "spark.openlineage.transport.type";
    public static final String SPARK_CONF_HTTP_URL = "spark.openlineage.transport.url";
    public static final String SPARK_CONF_JOB_NAME_APPEND_DATASET_NAME = "spark.openlineage.jobName.appendDatasetName";
    public static final String SPARK_CONF_JOB_NAME_REPLACE_DOT_WITH_UNDERSCORE = "spark.openlineage.jobName.replaceDotWithUnderscore";
    private static final String SPARK_CONF_FACETS_DISABLED = "spark.openlineage.facets.disabled";
    private static final String SPARK_CONF_DEBUG_FACET = "spark.openlineage.debugFacet";
    public static final Set<String> PROPERTIES_PREFIXES = new HashSet<String>(Arrays.asList("transport.properties.", "transport.urlParams.", "transport.headers."));
    private static final String disabledFacetsSeparator = ";";

    public static SparkOpenLineageConfig parse(SparkConf conf) {
        Optional<SparkOpenLineageConfig> configFromFile = ArgumentParser.extractOpenLineageConfFromFile();
        if ("http".equals(conf.get(SPARK_CONF_TRANSPORT_TYPE, ""))) {
            SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_HTTP_URL).ifPresent(url -> UrlParser.parseUrl(url).forEach((arg_0, arg_1) -> ((SparkConf)conf).set(arg_0, arg_1)));
        }
        SparkOpenLineageConfig configFromSparkConf = ArgumentParser.extractOpenLineageConfFromSparkConf(conf);
        SparkOpenLineageConfig targetConfig = configFromFile.isPresent() ? configFromFile.get().mergeWith(configFromSparkConf) : configFromSparkConf;
        if (targetConfig.getTransportConfig() == null) {
            targetConfig.setTransportConfig(new ConsoleConfig());
        }
        ArgumentParser.extractSparkSpecificConfigEntriesFromSparkConf(conf, targetConfig);
        return targetConfig;
    }

    private static Optional<SparkOpenLineageConfig> extractOpenLineageConfFromFile() {
        Optional<SparkOpenLineageConfig> configFromFile;
        try {
            configFromFile = Optional.of(OpenLineageClientUtils.loadOpenLineageConfigYaml(new DefaultConfigPathProvider(), new TypeReference<SparkOpenLineageConfig>(){}));
        }
        catch (OpenLineageClientException e) {
            log.info("Couldn't log config from file, will read it from SparkConf");
            configFromFile = Optional.empty();
        }
        return configFromFile;
    }

    private static void extractSparkSpecificConfigEntriesFromSparkConf(SparkConf conf, SparkOpenLineageConfig config) {
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_APP_NAME).filter(str -> !str.isEmpty()).ifPresent(config::setOverriddenAppName);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_NAMESPACE).ifPresent(config::setNamespace);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_PARENT_JOB_NAME).ifPresent(config::setParentJobName);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_PARENT_JOB_NAMESPACE).ifPresent(config::setParentJobNamespace);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_PARENT_RUN_ID).ifPresent(config::setParentRunId);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_DEBUG_FACET).ifPresent(config::setDebugFacet);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_JOB_NAME_APPEND_DATASET_NAME).map(Boolean::valueOf).ifPresent(v -> config.getJobName().setAppendDatasetName((Boolean)v));
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_JOB_NAME_REPLACE_DOT_WITH_UNDERSCORE).map(Boolean::valueOf).ifPresent(v -> config.getJobName().setReplaceDotWithUnderscore((Boolean)v));
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_FACETS_DISABLED).map(s -> s.replace(ARRAY_PREFIX_CHAR, "").replace(ARRAY_SUFFIX_CHAR, "")).map(s -> (String[])Stream.of(s.split(";")).filter(StringUtils::isNotBlank).toArray(String[]::new)).ifPresent(a -> config.getFacetsConfig().setDisabledFacets((String[])a));
    }

    private static SparkOpenLineageConfig extractOpenLineageConfFromSparkConf(SparkConf conf) {
        List<Tuple2<String, String>> properties = ArgumentParser.filterProperties(conf);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        for (Tuple2<String, String> c : properties) {
            ObjectNode nodePointer = objectNode;
            String keyPath = (String)c._1;
            String value = (String)c._2;
            if (!StringUtils.isNotBlank(value)) continue;
            List<String> pathKeys = ArgumentParser.getJsonPath(keyPath);
            List<String> nonLeafs = pathKeys.subList(0, pathKeys.size() - 1);
            String leaf = pathKeys.get(pathKeys.size() - 1);
            for (String node : nonLeafs) {
                if (nodePointer.get(node) == null) {
                    nodePointer.putObject(node);
                }
                nodePointer = (ObjectNode)nodePointer.get(node);
            }
            if (ArgumentParser.isArrayType(value) || SPARK_CONF_FACETS_DISABLED.equals("spark.openlineage." + keyPath)) {
                ArrayNode arrayNode = nodePointer.putArray(leaf);
                String valueWithoutBrackets = ArgumentParser.isArrayType(value) ? value.substring(1, value.length() - 1) : value;
                Arrays.stream(valueWithoutBrackets.split(";")).filter(StringUtils::isNotBlank).forEach(arrayNode::add);
                continue;
            }
            nodePointer.put(leaf, value);
        }
        try {
            return OpenLineageClientUtils.loadOpenLineageConfigYaml(new ByteArrayInputStream(objectMapper.writeValueAsBytes(objectNode)), new TypeReference<SparkOpenLineageConfig>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Tuple2<String, String>> filterProperties(SparkConf conf) {
        return Arrays.stream(conf.getAllWithPrefix("spark.openlineage.")).collect(Collectors.toList());
    }

    private static List<String> getJsonPath(String keyPath) {
        Optional<String> propertyPath = PROPERTIES_PREFIXES.stream().filter(keyPath::startsWith).findAny();
        List pathKeys = propertyPath.map(s -> {
            ArrayList<String> path = new ArrayList<String>(Arrays.asList(s.split("\\.")));
            path.add(keyPath.replaceFirst((String)s, ""));
            return path;
        }).orElseGet(() -> Arrays.asList(keyPath.split("\\.")));
        return pathKeys;
    }

    private static boolean isArrayType(String value) {
        return value.startsWith(ARRAY_PREFIX_CHAR) && value.endsWith(ARRAY_SUFFIX_CHAR) && value.contains(";");
    }

    public String toString() {
        return "ArgumentParser()";
    }
}

