/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClient;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.TransportFactory;
import io.openlineage.spark.api.SparkOpenLineageConfig;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter {
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);
    private OpenLineageClient client;
    private Optional<String> overriddenAppName;
    private String jobNamespace;
    private Optional<String> parentJobName;
    private Optional<String> parentJobNamespace;
    private Optional<UUID> parentRunId;
    private UUID applicationRunId;
    private String applicationJobName;
    private Optional<List<String>> customEnvironmentVariables;

    public EventEmitter(SparkOpenLineageConfig config, String applicationJobName) throws URISyntaxException {
        this.jobNamespace = config.getNamespace();
        this.parentJobName = Optional.ofNullable(config.getParentJobName());
        this.parentJobNamespace = Optional.ofNullable(config.getParentJobNamespace());
        this.parentRunId = EventEmitter.convertToUUID(config.getParentRunId());
        this.overriddenAppName = Optional.ofNullable(config.getOverriddenAppName());
        this.customEnvironmentVariables = config.getFacetsConfig() != null ? (config.getFacetsConfig().getCustomEnvironmentVariables() != null ? Optional.of(Arrays.asList(config.getFacetsConfig().getCustomEnvironmentVariables())) : Optional.empty()) : Optional.empty();
        String[] disabledFacets = config.getFacetsConfig().getDisabledFacets();
        this.client = OpenLineageClient.builder().transport(new TransportFactory(config.getTransportConfig()).build()).disableFacets(disabledFacets).build();
        this.applicationJobName = applicationJobName;
        this.applicationRunId = UUID.randomUUID();
    }

    public void emit(OpenLineage.RunEvent event) {
        try {
            this.client.emit(event);
            log.debug("Emitting lineage completed successfully: {}", (Object)OpenLineageClientUtils.toJson(event));
        }
        catch (OpenLineageClientException exception) {
            log.error("Could not emit lineage w/ exception", (Throwable)exception);
        }
    }

    private static Optional<UUID> convertToUUID(String uuid) {
        try {
            return Optional.ofNullable(uuid).map(UUID::fromString);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public OpenLineageClient getClient() {
        return this.client;
    }

    public Optional<String> getOverriddenAppName() {
        return this.overriddenAppName;
    }

    public String getJobNamespace() {
        return this.jobNamespace;
    }

    public Optional<String> getParentJobName() {
        return this.parentJobName;
    }

    public Optional<String> getParentJobNamespace() {
        return this.parentJobNamespace;
    }

    public Optional<UUID> getParentRunId() {
        return this.parentRunId;
    }

    public UUID getApplicationRunId() {
        return this.applicationRunId;
    }

    public String getApplicationJobName() {
        return this.applicationJobName;
    }

    public Optional<List<String>> getCustomEnvironmentVariables() {
        return this.customEnvironmentVariables;
    }
}

