/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import io.openlineage.spark.agent.facets.EnvironmentFacet;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomEnvironmentFacetBuilder
extends CustomFacetBuilder<SparkListenerEvent, EnvironmentFacet> {
    private static final Logger log = LoggerFactory.getLogger(CustomEnvironmentFacetBuilder.class);
    private Map<String, Object> envProperties;
    private List<String> customEnvironmentVariables;

    public CustomEnvironmentFacetBuilder() {
    }

    public CustomEnvironmentFacetBuilder(OpenLineageContext openLineageContext) {
        this.customEnvironmentVariables = openLineageContext.getCustomEnvironmentVariables();
    }

    @Override
    protected void build(SparkListenerEvent event, BiConsumer<String, ? super EnvironmentFacet> consumer) {
        consumer.accept("environment-properties", new EnvironmentFacet(this.getCustomEnvironmentalAttributes()));
    }

    private Map<String, Object> getCustomEnvironmentalAttributes() {
        this.envProperties = new HashMap<String, Object>();
        this.customEnvironmentVariables.forEach(envVar -> this.envProperties.put((String)envVar, System.getenv().get(envVar)));
        return this.envProperties;
    }

    @Override
    public boolean isDefinedAt(Object x) {
        return x instanceof SparkListenerEvent;
    }
}

