/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import io.openlineage.spark.agent.facets.EnvironmentFacet;
import io.openlineage.spark.agent.models.DatabricksMountpoint;
import io.openlineage.spark.agent.util.ReflectionUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;

public class DatabricksEnvironmentFacetBuilder
extends CustomFacetBuilder<SparkListenerJobStart, EnvironmentFacet> {
    private Map<String, Object> dbProperties;
    private static final Logger log = LoggerFactory.getLogger(DatabricksEnvironmentFacetBuilder.class);

    public static boolean isDatabricksRuntime() {
        return System.getenv().containsKey("DATABRICKS_RUNTIME_VERSION");
    }

    public DatabricksEnvironmentFacetBuilder() {
    }

    public DatabricksEnvironmentFacetBuilder(OpenLineageContext openLineageContext) {
        this.dbProperties = new HashMap<String, Object>();
        openLineageContext.getCustomEnvironmentVariables().forEach(envVar -> this.dbProperties.put((String)envVar, System.getenv().get(envVar)));
    }

    @Override
    protected void build(SparkListenerJobStart event, BiConsumer<String, ? super EnvironmentFacet> consumer) {
        consumer.accept("environment-properties", new EnvironmentFacet(this.getDatabricksEnvironmentalAttributes(event)));
    }

    private Map<String, Object> getDatabricksEnvironmentalAttributes(SparkListenerJobStart jobStart) {
        if (this.dbProperties == null) {
            this.dbProperties = new HashMap<String, Object>();
        }
        List<String> dbPropertiesKeys = Arrays.asList("orgId", "spark.databricks.clusterUsageTags.clusterOwnerOrgId", "spark.databricks.notebook.path", "spark.databricks.job.type", "spark.databricks.job.id", "spark.databricks.job.runId", "user", "userId", "spark.databricks.clusterUsageTags.clusterName", "spark.databricks.clusterUsageTags.clusterAllTags", "spark.databricks.clusterUsageTags.azureSubscriptionId");
        dbPropertiesKeys.stream().forEach(p -> this.dbProperties.put((String)p, jobStart.properties().getProperty((String)p)));
        this.dbProperties.put("mountPoints", DatabricksEnvironmentFacetBuilder.getDatabricksMountpoints());
        return this.dbProperties;
    }

    private static List<DatabricksMountpoint> getDatabricksMountpoints() {
        Object dbfsUtils;
        Class<?> dbutilsClass;
        try {
            dbutilsClass = Class.forName("com.databricks.dbutils_v1.impl.DbfsUtilsImpl");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            log.warn("Class com.databricks.dbutils_v1.impl.DbfsUtilsImpl not found", e);
            return Collections.emptyList();
        }
        Constructor<?>[] dbutilsConstructors = dbutilsClass.getDeclaredConstructors();
        if (dbutilsConstructors.length == 0) {
            log.warn("Failed to load dbutils in OpenLineageListener as there were no declared constructors");
            return Collections.emptyList();
        }
        Constructor<?> firstConstructor = dbutilsConstructors[0];
        Parameter[] constructorParams = firstConstructor.getParameters();
        if (constructorParams.length == 0) {
            log.debug("DbUtils constructor had no parameters");
            try {
                dbfsUtils = firstConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.warn("DbUtils method thrown {}", (Throwable)e);
                return Collections.emptyList();
            }
        } else if (constructorParams.length == 1 && "allowMountOperations".equals(constructorParams[0].getName())) {
            log.debug("DbUtils constructor had one parameter named allowMountOperations");
            try {
                dbfsUtils = firstConstructor.newInstance(true);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.warn("DbUtils method thrown {}", (Throwable)e);
                return Collections.emptyList();
            }
        } else {
            log.warn("dbutils had {} constructors and the first constructor had {} params", (Object)dbutilsConstructors.length, (Object)constructorParams.length);
            return Collections.emptyList();
        }
        ArrayList<DatabricksMountpoint> mountpoints = new ArrayList<DatabricksMountpoint>();
        List mountsList = ScalaConversionUtils.fromSeq((Seq)ReflectionUtils.tryExecuteMethod(dbfsUtils, "mounts", new Object[0]).get());
        for (Object mount : mountsList) {
            Optional<Object> mountPoint = ReflectionUtils.tryExecuteMethod(mount, "mountPoint", new Object[0]);
            Optional<Object> source = ReflectionUtils.tryExecuteMethod(mount, "source", new Object[0]);
            if (mountPoint.isPresent() && mountPoint.get() != null && source.isPresent() && source.get() != null) {
                mountpoints.add(new DatabricksMountpoint(mountPoint.get().toString(), source.get().toString()));
                continue;
            }
            log.warn("Couldn't extract mountPoint and source through reflection. mountPoint = {}, source = {}", mountPoint, source);
        }
        return mountpoints;
    }
}

