/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import io.openlineage.spark.agent.facets.LogicalPlanFacet;
import io.openlineage.spark.agent.util.FacetUtils;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.function.BiConsumer;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;

public class LogicalPlanRunFacetBuilder
extends CustomFacetBuilder<Object, LogicalPlanFacet> {
    private final OpenLineageContext openLineageContext;

    public LogicalPlanRunFacetBuilder(OpenLineageContext openLineageContext) {
        this.openLineageContext = openLineageContext;
    }

    @Override
    public boolean isDefinedAt(Object x) {
        if (FacetUtils.isFacetDisabled(this.openLineageContext, "spark.logicalPlan")) {
            return false;
        }
        return (x instanceof SparkListenerSQLExecutionEnd || x instanceof SparkListenerSQLExecutionStart || x instanceof SparkListenerJobStart || x instanceof SparkListenerJobEnd) && this.openLineageContext.getQueryExecution().isPresent();
    }

    @Override
    protected void build(Object event, BiConsumer<String, ? super LogicalPlanFacet> consumer) {
        this.openLineageContext.getQueryExecution().ifPresent(qe -> consumer.accept("spark.logicalPlan", LogicalPlanFacet.builder().plan(qe.optimizedPlan()).build()));
    }
}

