/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import io.openlineage.spark.agent.facets.SparkPropertyFacet;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPropertyFacetBuilder
extends CustomFacetBuilder<SparkListenerEvent, SparkPropertyFacet> {
    private static final Logger log = LoggerFactory.getLogger(SparkPropertyFacetBuilder.class);
    private static final Set<String> DEFAULT_ALLOWED_PROPERTIES = new HashSet<String>(Arrays.asList("spark.master", "spark.app.name"));
    private static final String ALLOWED_PROPERTIES_KEY = "spark.openlineage.capturedProperties";
    private SparkConf conf;
    private Set<String> allowerProperties;

    public SparkPropertyFacetBuilder(OpenLineageContext context) {
        this.fillConfAndAllowerProperties(context.getSparkContext());
    }

    public SparkPropertyFacetBuilder() {
        try {
            SparkSession session = SparkSession.active();
            this.fillConfAndAllowerProperties(session.sparkContext());
        }
        catch (IllegalStateException ie) {
            log.info("No active or default Spark session found");
            this.conf = new SparkConf();
            this.allowerProperties = new HashSet<String>();
        }
    }

    private void fillConfAndAllowerProperties(SparkContext context) {
        this.conf = context.getConf();
        this.allowerProperties = this.conf.contains(ALLOWED_PROPERTIES_KEY) ? Arrays.stream(this.conf.get(ALLOWED_PROPERTIES_KEY).split(",")).collect(Collectors.toSet()) : DEFAULT_ALLOWED_PROPERTIES;
    }

    @Override
    protected void build(SparkListenerEvent event, BiConsumer<String, ? super SparkPropertyFacet> consumer) {
        consumer.accept("spark_properties", this.buildFacet(event));
    }

    public SparkPropertyFacet buildFacet(SparkListenerEvent event) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Arrays.stream(this.conf.getAll()).filter(t -> this.allowerProperties.contains(t._1)).forEach(t -> m.putIfAbsent((String)t._1, t._2));
        if (event instanceof SparkListenerJobStart) {
            SparkListenerJobStart startEvent = (SparkListenerJobStart)event;
            startEvent.properties().entrySet().stream().filter(e -> this.allowerProperties.contains(e.getKey())).forEach(e -> m.putIfAbsent(e.getKey().toString(), e.getValue()));
        }
        try {
            SparkSession session = SparkSession.active();
            this.allowerProperties.forEach(item -> m.putIfAbsent((String)item, session.conf().get(item)));
        }
        catch (RuntimeException e2) {
            log.info("Cannot add SparkPropertyFacet: Spark session is in a wrong status or a key in capturedProperties does not exist in run-time config");
        }
        return new SparkPropertyFacet(m);
    }
}

