/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.filters;

import io.openlineage.spark.agent.filters.AdaptivePlanEventFilter;
import io.openlineage.spark.agent.filters.CreateViewFilter;
import io.openlineage.spark.agent.filters.DatabricksEventFilter;
import io.openlineage.spark.agent.filters.DeltaEventFilter;
import io.openlineage.spark.agent.filters.SparkNodesFilter;
import io.openlineage.spark.agent.util.SparkSessionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Arrays;
import java.util.Optional;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;

public class EventFilterUtils {
    public static boolean isDisabled(OpenLineageContext context, SparkListenerEvent event) {
        return Arrays.asList(new DeltaEventFilter(context), new DatabricksEventFilter(context), new SparkNodesFilter(context), new CreateViewFilter(context), new AdaptivePlanEventFilter(context)).stream().filter(filter -> filter.isDisabled((SparkListenerEvent)event.getClass().cast(event))).findAny().isPresent();
    }

    static Optional<LogicalPlan> getLogicalPlan(OpenLineageContext context) {
        return context.getQueryExecution().filter(queryExecution -> queryExecution != null).map(queryExecution -> queryExecution.optimizedPlan()).filter(plan -> plan != null);
    }

    static boolean isDeltaPlan() {
        return SparkSessionUtils.activeSession().map(SparkSession::sparkContext).filter(context -> context != null).map(SparkContext::conf).map(conf -> conf.get("spark.sql.extensions", "")).filter(extension -> "io.delta.sql.DeltaSparkSessionExtension".equals(extension)).isPresent();
    }
}

