/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.VisitorFactory;
import io.openlineage.spark.agent.lifecycle.plan.AlterTableAddColumnsCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.AlterTableAddPartitionCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.AlterTableRenameCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.AlterTableSetLocationCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.BigQueryNodeInputVisitor;
import io.openlineage.spark.agent.lifecycle.plan.BigQueryNodeOutputVisitor;
import io.openlineage.spark.agent.lifecycle.plan.CreateDataSourceTableAsSelectCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.CreateDataSourceTableCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.CreateHiveTableAsSelectCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.CreateTableCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.DropTableCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.ExternalRDDVisitor;
import io.openlineage.spark.agent.lifecycle.plan.HiveTableRelationVisitor;
import io.openlineage.spark.agent.lifecycle.plan.InsertIntoDataSourceDirVisitor;
import io.openlineage.spark.agent.lifecycle.plan.InsertIntoDataSourceVisitor;
import io.openlineage.spark.agent.lifecycle.plan.InsertIntoDirVisitor;
import io.openlineage.spark.agent.lifecycle.plan.InsertIntoHadoopFsRelationVisitor;
import io.openlineage.spark.agent.lifecycle.plan.InsertIntoHiveDirVisitor;
import io.openlineage.spark.agent.lifecycle.plan.InsertIntoHiveTableVisitor;
import io.openlineage.spark.agent.lifecycle.plan.KafkaRelationVisitor;
import io.openlineage.spark.agent.lifecycle.plan.KustoRelationVisitor;
import io.openlineage.spark.agent.lifecycle.plan.LoadDataCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.LogicalRDDVisitor;
import io.openlineage.spark.agent.lifecycle.plan.OptimizedCreateHiveTableAsSelectCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.SqlDWDatabricksVisitor;
import io.openlineage.spark.agent.lifecycle.plan.SqlExecutionRDDVisitor;
import io.openlineage.spark.agent.lifecycle.plan.TruncateTableCommandVisitor;
import io.openlineage.spark.agent.util.BigQueryUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.PartialFunction;

abstract class BaseVisitorFactory
implements VisitorFactory {
    BaseVisitorFactory() {
    }

    protected <D extends OpenLineage.Dataset> List<PartialFunction<LogicalPlan, List<D>>> getBaseCommonVisitors(OpenLineageContext context, DatasetFactory<D> factory) {
        ArrayList<PartialFunction<LogicalPlan, List<D>>> list = new ArrayList<PartialFunction<LogicalPlan, List<D>>>();
        list.add((PartialFunction<LogicalPlan, List<D>>)new LogicalRDDVisitor<D>(context, factory));
        if (KafkaRelationVisitor.hasKafkaClasses()) {
            list.add((PartialFunction<LogicalPlan, List<D>>)new KafkaRelationVisitor<D>(context, factory));
        }
        if (SqlDWDatabricksVisitor.hasSqlDWDatabricksClasses()) {
            list.add((PartialFunction<LogicalPlan, List<D>>)new SqlDWDatabricksVisitor<D>(context, factory));
        }
        if (InsertIntoHiveTableVisitor.hasHiveClasses()) {
            list.add((PartialFunction<LogicalPlan, List<D>>)new HiveTableRelationVisitor<D>(context, factory));
        }
        if (KustoRelationVisitor.hasKustoClasses()) {
            list.add((PartialFunction<LogicalPlan, List<D>>)new KustoRelationVisitor<D>(context, factory));
        }
        return list;
    }

    public abstract <D extends OpenLineage.Dataset> List<PartialFunction<LogicalPlan, List<D>>> getCommonVisitors(OpenLineageContext var1, DatasetFactory<D> var2);

    @Override
    public List<PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>> getInputVisitors(OpenLineageContext context) {
        DatasetFactory<OpenLineage.InputDataset> factory = DatasetFactory.input(context);
        ArrayList<PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>> inputVisitors = new ArrayList<PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>>(this.getCommonVisitors(context, factory));
        if (BigQueryUtils.hasBigQueryClasses()) {
            inputVisitors.add((PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>)new BigQueryNodeInputVisitor(context, factory));
        }
        if (VisitorFactory.classPresent("org.apache.spark.sql.execution.SQLExecutionRDD")) {
            inputVisitors.add((PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>)new SqlExecutionRDDVisitor(context));
        }
        inputVisitors.add((PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>)new ExternalRDDVisitor(context));
        return inputVisitors;
    }

    @Override
    public List<PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>> getOutputVisitors(OpenLineageContext context) {
        DatasetFactory<OpenLineage.OutputDataset> factory = DatasetFactory.output(context);
        List<PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>> outputCommonVisitors = this.getCommonVisitors(context, factory);
        ArrayList<PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>> list = new ArrayList<PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>>(outputCommonVisitors);
        if (BigQueryUtils.hasBigQueryClasses()) {
            list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new BigQueryNodeOutputVisitor(context, factory));
        }
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new InsertIntoDataSourceDirVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new InsertIntoDataSourceVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new InsertIntoHadoopFsRelationVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new CreateDataSourceTableAsSelectCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new InsertIntoDirVisitor(context));
        if (InsertIntoHiveTableVisitor.hasHiveClasses()) {
            list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new InsertIntoHiveTableVisitor(context));
            list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new InsertIntoHiveDirVisitor(context));
            list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new CreateHiveTableAsSelectCommandVisitor(context));
        }
        if (OptimizedCreateHiveTableAsSelectCommandVisitor.hasClasses()) {
            list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new OptimizedCreateHiveTableAsSelectCommandVisitor(context));
        }
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new CreateDataSourceTableCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new LoadDataCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new AlterTableRenameCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new AlterTableAddColumnsCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new CreateTableCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new DropTableCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new TruncateTableCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new AlterTableSetLocationCommandVisitor(context));
        list.add((PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>)new AlterTableAddPartitionCommandVisitor(context));
        return list;
    }
}

