/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import com.google.common.collect.ImmutableList;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.facets.builder.CustomEnvironmentFacetBuilder;
import io.openlineage.spark.agent.facets.builder.DatabricksEnvironmentFacetBuilder;
import io.openlineage.spark.agent.facets.builder.DebugRunFacetBuilder;
import io.openlineage.spark.agent.facets.builder.ErrorFacetBuilder;
import io.openlineage.spark.agent.facets.builder.LogicalPlanRunFacetBuilder;
import io.openlineage.spark.agent.facets.builder.OutputStatisticsOutputDatasetFacetBuilder;
import io.openlineage.spark.agent.facets.builder.OwnershipJobFacetBuilder;
import io.openlineage.spark.agent.facets.builder.SparkProcessingEngineRunFacetBuilder;
import io.openlineage.spark.agent.facets.builder.SparkPropertyFacetBuilder;
import io.openlineage.spark.agent.facets.builder.SparkVersionFacetBuilder;
import io.openlineage.spark.agent.lifecycle.DatasetBuilderFactoryProvider;
import io.openlineage.spark.agent.lifecycle.VisitorFactory;
import io.openlineage.spark.agent.lifecycle.VisitorFactoryProvider;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageVisitor;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.OpenLineageEventHandlerFactory;
import io.openlineage.spark.api.Vendors;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.PartialFunction;

class InternalEventHandlerFactory
implements OpenLineageEventHandlerFactory {
    private final List<OpenLineageEventHandlerFactory> eventHandlerFactories;
    private final List<VisitorFactory> visitorFactory;

    public InternalEventHandlerFactory() {
        ServiceLoader<OpenLineageEventHandlerFactory> loader = ServiceLoader.load(OpenLineageEventHandlerFactory.class);
        this.eventHandlerFactories = Stream.concat(StreamSupport.stream(Spliterators.spliteratorUnknownSize(loader.iterator(), 0), false), Vendors.getVendors().getEventHandlerFactories().stream()).collect(Collectors.toList());
        this.visitorFactory = ImmutableList.builder().add((Object)VisitorFactoryProvider.getInstance()).addAll(Vendors.getVendors().getVisitorFactories()).build();
    }

    private <T> List<T> generate(Collection<OpenLineageEventHandlerFactory> factories, Function<OpenLineageEventHandlerFactory, Collection<T>> supplier) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(factories.iterator(), 1024), false).flatMap(supplier.andThen(Collection::stream)).collect(Collectors.toList());
    }

    @Override
    public Collection<PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>> createInputDatasetQueryPlanVisitors(OpenLineageContext context) {
        List inputDatasets = this.visitorFactory.stream().flatMap(v -> v.getInputVisitors(context).stream()).collect(Collectors.toList());
        ImmutableList inputDatasetVisitors = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createInputDatasetQueryPlanVisitors(context))).addAll(inputDatasets).build();
        context.getInputDatasetQueryPlanVisitors().addAll((Collection<PartialFunction<LogicalPlan, List<OpenLineage.InputDataset>>>)inputDatasetVisitors);
        return inputDatasetVisitors;
    }

    @Override
    public Collection<PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>> createOutputDatasetQueryPlanVisitors(OpenLineageContext context) {
        List outputDatasets = this.visitorFactory.stream().flatMap(v -> v.getOutputVisitors(context).stream()).collect(Collectors.toList());
        ImmutableList outputDatasetBuilders = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createOutputDatasetQueryPlanVisitors(context))).addAll(outputDatasets).build();
        context.getOutputDatasetQueryPlanVisitors().addAll((Collection<PartialFunction<LogicalPlan, List<OpenLineage.OutputDataset>>>)outputDatasetBuilders);
        return outputDatasetBuilders;
    }

    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.InputDataset>>> createInputDatasetBuilder(OpenLineageContext context) {
        ImmutableList builders = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createInputDatasetBuilder(context))).addAll(DatasetBuilderFactoryProvider.getInstance().getInputBuilders(context)).build();
        context.getInputDatasetBuilders().addAll((Collection<PartialFunction<Object, Collection<OpenLineage.InputDataset>>>)builders);
        return builders;
    }

    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.OutputDataset>>> createOutputDatasetBuilder(OpenLineageContext context) {
        ImmutableList outputDatasetBuilders = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createOutputDatasetBuilder(context))).addAll(DatasetBuilderFactoryProvider.getInstance().getOutputBuilders(context)).build();
        context.getOutputDatasetBuilders().addAll((Collection<PartialFunction<Object, Collection<OpenLineage.OutputDataset>>>)outputDatasetBuilders);
        return outputDatasetBuilders;
    }

    @Override
    public Collection<CustomFacetBuilder<?, ? extends OpenLineage.InputDatasetFacet>> createInputDatasetFacetBuilders(OpenLineageContext context) {
        return this.generate(this.eventHandlerFactories, factory -> factory.createInputDatasetFacetBuilders(context));
    }

    @Override
    public Collection<CustomFacetBuilder<?, ? extends OpenLineage.OutputDatasetFacet>> createOutputDatasetFacetBuilders(OpenLineageContext context) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createOutputDatasetFacetBuilders(context)));
        if (context.getSparkVersion().startsWith("3")) {
            builder.add((Object)new OutputStatisticsOutputDatasetFacetBuilder(context));
        }
        return builder.build();
    }

    @Override
    public Collection<CustomFacetBuilder<?, ? extends OpenLineage.DatasetFacet>> createDatasetFacetBuilders(OpenLineageContext context) {
        return this.generate(this.eventHandlerFactories, factory -> factory.createDatasetFacetBuilders(context));
    }

    @Override
    public Collection<CustomFacetBuilder<?, ? extends OpenLineage.RunFacet>> createRunFacetBuilders(OpenLineageContext context) {
        ImmutableList.Builder listBuilder = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createRunFacetBuilders(context))).add((Object[])new CustomFacetBuilder[]{new ErrorFacetBuilder(), new LogicalPlanRunFacetBuilder(context), new DebugRunFacetBuilder(context), new SparkVersionFacetBuilder(context), new SparkPropertyFacetBuilder(context), new SparkProcessingEngineRunFacetBuilder(context)});
        if (DatabricksEnvironmentFacetBuilder.isDatabricksRuntime()) {
            listBuilder.add((Object)new DatabricksEnvironmentFacetBuilder(context));
        } else if (context.getCustomEnvironmentVariables() != null) {
            listBuilder.add((Object)new CustomEnvironmentFacetBuilder(context));
        }
        return listBuilder.build();
    }

    public List<CustomFacetBuilder<?, ? extends OpenLineage.JobFacet>> createJobFacetBuilders(OpenLineageContext context) {
        ImmutableList.Builder listBuilder = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createJobFacetBuilders(context)));
        listBuilder.add((Object)new OwnershipJobFacetBuilder(context));
        return listBuilder.build();
    }

    public List<ColumnLevelLineageVisitor> createColumnLevelLineageVisitors(OpenLineageContext context) {
        ImmutableList visitors = ImmutableList.builder().addAll(this.generate(this.eventHandlerFactories, factory -> factory.createColumnLevelLineageVisitors(context))).addAll(DatasetBuilderFactoryProvider.getInstance().getColumnLevelLineageVisitors(context)).build();
        context.getColumnLevelLineageVisitors().addAll((Collection<ColumnLevelLineageVisitor>)visitors);
        return visitors;
    }
}

