/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import io.openlineage.spark.agent.facets.UnknownEntryFacet;
import io.openlineage.spark.agent.lifecycle.LogicalPlanSerializer;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownEntryFacetListener
implements Consumer<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(UnknownEntryFacetListener.class);
    private final Map<LogicalPlan, Object> visitedNodes = new IdentityHashMap<LogicalPlan, Object>();
    private final LogicalPlanSerializer planSerializer = new LogicalPlanSerializer();
    private static final UnknownEntryFacetListener INSTANCE = new UnknownEntryFacetListener();

    public static UnknownEntryFacetListener getInstance() {
        return INSTANCE;
    }

    @Override
    public void accept(LogicalPlan logicalPlan) {
        this.visitedNodes.put(logicalPlan, null);
    }

    public void clear() {
        this.visitedNodes.clear();
    }

    @VisibleForTesting
    public Integer getVisitedNodesSize() {
        return this.visitedNodes.size();
    }

    public Optional<UnknownEntryFacet> build(LogicalPlan root) {
        try {
            return this.buildFacet(root);
        }
        catch (Exception exception) {
            log.warn("Failed to serialize unknown entry facet: %s", (Throwable)exception);
            return Optional.empty();
        }
    }

    private Optional<UnknownEntryFacet> buildFacet(LogicalPlan root) {
        Optional<UnknownEntryFacet.FacetEntry> output = this.mapEntry(root);
        List<UnknownEntryFacet.FacetEntry> inputs = ScalaConversionUtils.fromSeq(root.collectLeaves()).stream().map(this::mapEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return !output.isPresent() && inputs.isEmpty() ? Optional.empty() : Optional.of(new UnknownEntryFacet(output.orElse(null), inputs));
    }

    private Optional<UnknownEntryFacet.FacetEntry> mapEntry(LogicalPlan x) {
        if (this.visitedNodes.containsKey(x)) {
            log.debug("Node was visited - ignoring {}", (Object)x);
            return Optional.empty();
        }
        List<UnknownEntryFacet.AttributeField> output = this.attributeFields(x.outputSet());
        List<UnknownEntryFacet.AttributeField> input = this.attributeFields(x.inputSet());
        String serializedNode = this.planSerializer.serialize(x);
        log.debug("Adding serialized node for unknown facet entry {}", (Object)serializedNode);
        return Optional.of(new UnknownEntryFacet.FacetEntry(serializedNode, input, output));
    }

    private List<UnknownEntryFacet.AttributeField> attributeFields(AttributeSet set) {
        return ScalaConversionUtils.fromSet(set.toSet()).stream().map(this::mapAttributeReference).collect(Collectors.toList());
    }

    private UnknownEntryFacet.AttributeField mapAttributeReference(AttributeReference ar) {
        return new UnknownEntryFacet.AttributeField(ar.name(), Optional.ofNullable(ar.dataType()).map(DataType::typeName).orElse(null), new HashMap<String, Object>(ScalaConversionUtils.fromMap(ar.metadata().map())));
    }
}

