/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.StructType;

public abstract class AbstractRDDNodeVisitor<T extends LogicalPlan, D extends OpenLineage.Dataset>
extends QueryPlanVisitor<T, D> {
    protected final DatasetFactory<D> datasetFactory;

    public AbstractRDDNodeVisitor(@NonNull OpenLineageContext context, DatasetFactory<D> datasetFactory) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.datasetFactory = datasetFactory;
    }

    protected List<D> findInputDatasets(List<RDD<?>> fileRdds, StructType schema) {
        return PlanUtils.findRDDPaths(fileRdds).stream().map(p -> this.datasetFactory.getDataset(p.toUri(), schema)).collect(Collectors.toList());
    }
}

