/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableRenameCommandVisitor
extends QueryPlanVisitor<AlterTableRenameCommand, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(AlterTableRenameCommandVisitor.class);

    public AlterTableRenameCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        Optional<CatalogTable> tableOpt = this.catalogTableFor(((AlterTableRenameCommand)x).newName());
        if (!tableOpt.isPresent()) {
            return Collections.emptyList();
        }
        CatalogTable table = tableOpt.get();
        DatasetIdentifier di = PathUtils.fromCatalogTable(table);
        AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)x;
        String previousName = di.getName().replace(alterTableRenameCommand.newName().table(), alterTableRenameCommand.oldName().table());
        OpenLineage.LifecycleStateChangeDatasetFacet lifecycleStateChangeDatasetFacet = this.context.getOpenLineage().newLifecycleStateChangeDatasetFacetBuilder().lifecycleStateChange(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.RENAME).previousIdentifier(new OpenLineage.LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder().name(previousName).namespace(di.getNamespace()).build()).build();
        DatasetFactory<OpenLineage.OutputDataset> factory = this.outputDataset();
        return Collections.singletonList(factory.getDataset(di, new OpenLineage.DatasetFacetsBuilder().schema(PlanUtils.schemaFacet(this.context.getOpenLineage(), table.schema())).dataSource(PlanUtils.datasourceFacet(this.context.getOpenLineage(), di.getNamespace())).lifecycleStateChange(lifecycleStateChangeDatasetFacet)));
    }
}

