/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import com.google.cloud.spark.bigquery.BigQueryRelation;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.SqlUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import io.openlineage.spark.extension.scala.v1.LineageRelation;
import io.openlineage.spark.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryNodeInputVisitor
extends QueryPlanVisitor<LogicalPlan, OpenLineage.InputDataset> {
    private static final Logger log = LoggerFactory.getLogger(BigQueryNodeInputVisitor.class);
    private static final String BIGQUERY_NAMESPACE = "bigquery";
    private final DatasetFactory<OpenLineage.InputDataset> factory;

    public BigQueryNodeInputVisitor(OpenLineageContext context, DatasetFactory<OpenLineage.InputDataset> factory) {
        super(context);
        this.factory = factory;
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return plan instanceof LogicalRelation && !(((LogicalRelation)plan).relation() instanceof LineageRelation) && ((LogicalRelation)plan).relation() instanceof BigQueryRelation;
    }

    private Optional<Supplier<BigQueryRelation>> bigQuerySupplier(LogicalPlan plan) {
        if (plan instanceof LogicalRelation && ((LogicalRelation)plan).relation() instanceof BigQueryRelation) {
            return Optional.of(() -> (BigQueryRelation)((LogicalRelation)plan).relation());
        }
        return Optional.empty();
    }

    public List<OpenLineage.InputDataset> apply(LogicalPlan plan) {
        return this.bigQuerySupplier(plan).map(s -> (BigQueryRelation)s.get()).map(relation -> {
            List<OpenLineage.InputDataset> datasets;
            if (relation instanceof DirectBigQueryRelation && !(datasets = this.tryGetFromQuery((DirectBigQueryRelation)relation)).isEmpty()) {
                return datasets;
            }
            return Collections.singletonList(this.factory.getDataset(this.getBigQueryTableName((BigQueryRelation)relation).get(), BIGQUERY_NAMESPACE, relation.schema()));
        }).orElse(Collections.emptyList());
    }

    private List<OpenLineage.InputDataset> tryGetFromQuery(DirectBigQueryRelation relation) {
        try {
            SparkBigQueryConfig config = (SparkBigQueryConfig)FieldUtils.readField((Object)relation, (String)"options", (boolean)true);
            if (config.getQuery().isPresent()) {
                return SqlUtils.getDatasets(this.factory, (String)config.getQuery().get(), BIGQUERY_NAMESPACE, BIGQUERY_NAMESPACE);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
            log.error("Could not invoke method", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private Optional<String> getBigQueryTableName(BigQueryRelation relation) {
        if (MethodUtils.getAccessibleMethod(relation.getClass(), "tableName", new Class[0]) != null) {
            try {
                return Optional.of((String)MethodUtils.invokeMethod(relation, "tableName"));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Could not invoke method", (Throwable)e);
            }
        } else if (MethodUtils.getAccessibleMethod(relation.getClass(), "getTableName", new Class[0]) != null) {
            try {
                return Optional.of((String)MethodUtils.invokeMethod(relation, "getTableName"));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Could not invoke method", (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

