/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import com.google.cloud.spark.bigquery.BigQueryRelationProvider;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ReflectionUtils;
import io.openlineage.spark.agent.util.SparkSessionUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import io.openlineage.spark.extension.scala.v1.LineageRelationProvider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.SaveIntoDataSourceCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class BigQueryNodeOutputVisitor
extends QueryPlanVisitor<LogicalPlan, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(BigQueryNodeOutputVisitor.class);
    private static final String BIGQUERY_NAMESPACE = "bigquery";
    private final DatasetFactory<OpenLineage.OutputDataset> factory;

    public BigQueryNodeOutputVisitor(OpenLineageContext context, DatasetFactory<OpenLineage.OutputDataset> factory) {
        super(context);
        this.factory = factory;
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return plan instanceof SaveIntoDataSourceCommand && !(((SaveIntoDataSourceCommand)plan).dataSource() instanceof LineageRelationProvider) && ((SaveIntoDataSourceCommand)plan).dataSource() instanceof BigQueryRelationProvider;
    }

    private String getFromSaveIntoDataSourceCommand(SaveIntoDataSourceCommand saveCommand, SparkSession session) {
        SQLContext sqlContext = session.sqlContext();
        BigQueryRelationProvider bqRelationProvider = (BigQueryRelationProvider)saveCommand.dataSource();
        SparkBigQueryConfig config = bqRelationProvider.createSparkBigQueryConfig(sqlContext, saveCommand.options(), Option.apply((Object)saveCommand.schema()));
        return this.getBigQueryTableName(config).get();
    }

    private static Optional<Object> extractDatasetIdentifierFromTableId(Object tableId) {
        return Stream.of(ReflectionUtils.tryExecuteStaticMethodForClassName("com.google.cloud.bigquery.connector.common.BigQueryUtil", "friendlyTableName", tableId), ReflectionUtils.tryExecuteStaticMethodForClassName("com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.connector.common.BigQueryUtil", "friendlyTableName", tableId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<String> getBigQueryTableName(SparkBigQueryConfig config) {
        return ReflectionUtils.tryExecuteMethod(config, "getTableId", new Object[0]).flatMap(BigQueryNodeOutputVisitor::extractDatasetIdentifierFromTableId).map(x -> (String)x);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan plan) {
        SaveIntoDataSourceCommand saveCommand = (SaveIntoDataSourceCommand)plan;
        Optional<SparkSession> session = SparkSessionUtils.activeSession();
        if (session.isPresent()) {
            return Collections.singletonList(this.factory.getDataset(this.getFromSaveIntoDataSourceCommand(saveCommand, session.get()), BIGQUERY_NAMESPACE, saveCommand.schema()));
        }
        return Collections.emptyList();
    }
}

