/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CreateDataSourceTableAsSelectCommand;
import org.apache.spark.sql.types.StructType;

public class CreateDataSourceTableAsSelectCommandVisitor
extends QueryPlanVisitor<CreateDataSourceTableAsSelectCommand, OpenLineage.OutputDataset> {
    public CreateDataSourceTableAsSelectCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        CreateDataSourceTableAsSelectCommand command = (CreateDataSourceTableAsSelectCommand)x;
        CatalogTable catalogTable = command.table();
        StructType schema = catalogTable.schema();
        if (schema.fields().length == 0 && command.query().schema().fields().length > 0) {
            schema = command.query().schema();
        }
        return Collections.singletonList(this.outputDataset().getDataset(PathUtils.fromCatalogTable(catalogTable), schema, OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE));
    }
}

