/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.hive.execution.CreateHiveTableAsSelectCommand;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class CreateHiveTableAsSelectCommandVisitor
extends QueryPlanVisitor<CreateHiveTableAsSelectCommand, OpenLineage.OutputDataset> {
    public CreateHiveTableAsSelectCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        CreateHiveTableAsSelectCommand command = (CreateHiveTableAsSelectCommand)x;
        CatalogTable table = command.tableDesc();
        DatasetIdentifier di = PathUtils.fromCatalogTable(table);
        LogicalPlan query = command.query();
        List attributes = ScalaConversionUtils.fromSeq(command.query().output());
        ArrayList<Attribute> schemaAttributes = new ArrayList<Attribute>();
        IntStream.range(0, attributes.size()).filter(index -> index < query.output().size()).forEach(index -> schemaAttributes.add(((Attribute)attributes.get(index)).withName((String)command.outputColumnNames().apply(index))));
        return Collections.singletonList(this.outputDataset().getDataset(di, this.outputSchema(schemaAttributes), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE));
    }

    private StructType outputSchema(List<Attribute> attrs) {
        return new StructType((StructField[])attrs.stream().map(a -> new StructField(a.name(), a.dataType(), a.nullable(), a.metadata())).toArray(StructField[]::new));
    }
}

