/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.hive.execution.OptimizedCreateHiveTableAsSelectCommand;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class OptimizedCreateHiveTableAsSelectCommandVisitor
extends QueryPlanVisitor<OptimizedCreateHiveTableAsSelectCommand, OpenLineage.OutputDataset> {
    public OptimizedCreateHiveTableAsSelectCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public static boolean hasClasses() {
        try {
            OptimizedCreateHiveTableAsSelectCommandVisitor.class.getClassLoader().loadClass("org.apache.spark.sql.hive.execution.OptimizedCreateHiveTableAsSelectCommand");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return plan instanceof OptimizedCreateHiveTableAsSelectCommand;
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        OptimizedCreateHiveTableAsSelectCommand command = (OptimizedCreateHiveTableAsSelectCommand)x;
        CatalogTable table = command.tableDesc();
        DatasetIdentifier datasetIdentifier = PathUtils.fromCatalogTable(table);
        StructType schema = this.outputSchema(ScalaConversionUtils.fromSeq(command.outputColumns()));
        OpenLineage.OutputDataset outputDataset = SaveMode.Overwrite == command.mode() ? this.outputDataset().getDataset(datasetIdentifier, schema, OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE) : this.outputDataset().getDataset(datasetIdentifier, schema);
        return Collections.singletonList(outputDataset);
    }

    private StructType outputSchema(List<Attribute> attrs) {
        return new StructType((StructField[])attrs.stream().map(a -> new StructField(a.name(), a.dataType(), a.nullable(), a.metadata())).toArray(StructField[]::new));
    }
}

