/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import io.openlineage.spark.api.OpenLineageContext;
import java.util.Optional;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksUtils {
    private static final Logger log = LoggerFactory.getLogger(DatabricksUtils.class);
    public static final String SPARK_DATABRICKS_WORKSPACE_URL = "spark.databricks.workspaceUrl";

    public static boolean isRunOnDatabricksPlatform(OpenLineageContext context) {
        return DatabricksUtils.getWorkspaceUrl(context).isPresent();
    }

    public static Optional<String> getWorkspaceUrl(OpenLineageContext context) {
        return context.getQueryExecution().map(QueryExecution::sparkSession).map(SparkSession::sparkContext).map(SparkContext::getConf).filter(conf -> conf.contains(SPARK_DATABRICKS_WORKSPACE_URL)).map(conf -> conf.get(SPARK_DATABRICKS_WORKSPACE_URL));
    }

    public static String prettifyDatabricksJobName(OpenLineageContext context, String jobName) {
        return jobName.replace("databricks_shell.", DatabricksUtils.extractWorkspaceId(DatabricksUtils.getWorkspaceUrl(context).get() + "."));
    }

    private static String extractWorkspaceId(String workspaceUrl) {
        return workspaceUrl.replace(".cloud.databricks.com/", "").replace("https://", "");
    }
}

