/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.client.utils.DatasetIdentifierUtils;
import io.openlineage.spark.agent.util.SparkConfUtils;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.internal.StaticSQLConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    private static final String DEFAULT_SCHEME = "file";
    private static final String DEFAULT_SEPARATOR = "/";
    private static Optional<SparkConf> sparkConf = Optional.empty();

    public static DatasetIdentifier fromPath(Path path) {
        return PathUtils.fromPath(path, DEFAULT_SCHEME);
    }

    public static DatasetIdentifier fromPath(Path path, String defaultScheme) {
        return PathUtils.fromURI(path.toUri(), defaultScheme);
    }

    public static DatasetIdentifier fromURI(URI location) {
        return PathUtils.fromURI(location, DEFAULT_SCHEME);
    }

    public static DatasetIdentifier fromURI(URI location, String defaultScheme) {
        return DatasetIdentifierUtils.fromURI(location, defaultScheme);
    }

    public static DatasetIdentifier fromCatalogTable(CatalogTable catalogTable) {
        return PathUtils.fromCatalogTable(catalogTable, PathUtils.loadSparkConf());
    }

    public static DatasetIdentifier fromCatalogTable(CatalogTable catalogTable, Optional<SparkConf> sparkConf) {
        DatasetIdentifier di;
        URI uri;
        if (catalogTable.storage() != null && catalogTable.storage().locationUri().isDefined()) {
            uri = PathUtils.prepareUriFromLocation(catalogTable);
            di = PathUtils.fromURI(uri, DEFAULT_SCHEME);
        } else {
            try {
                uri = PathUtils.prepareUriFromDefaultTablePath(catalogTable);
                di = PathUtils.fromURI(uri, DEFAULT_SCHEME);
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("Unable to extract DatasetIdentifier from a CatalogTable", e);
            }
        }
        Optional<URI> metastoreUri = PathUtils.extractMetastoreUri(sparkConf);
        if (metastoreUri.isPresent() && metastoreUri.get() != null) {
            DatasetIdentifier symlink = PathUtils.prepareHiveDatasetIdentifier(catalogTable, metastoreUri.get());
            return di.withSymlink(symlink.getName(), symlink.getNamespace(), DatasetIdentifier.SymlinkType.TABLE);
        }
        return di.withSymlink(PathUtils.nameFromTableIdentifier(catalogTable.identifier()), StringUtils.substringBeforeLast((String)uri.toString(), (String)File.separator), DatasetIdentifier.SymlinkType.TABLE);
    }

    private static URI prepareUriFromDefaultTablePath(CatalogTable catalogTable) {
        URI uri = SparkSession.active().sessionState().catalog().defaultTablePath(catalogTable.identifier());
        return uri;
    }

    private static URI prepareUriFromLocation(CatalogTable catalogTable) {
        URI uri = (URI)catalogTable.storage().locationUri().get();
        if (uri.getPath() != null && uri.getPath().startsWith(DEFAULT_SEPARATOR) && uri.getScheme() == null) {
            uri = new URI(DEFAULT_SCHEME, null, uri.getPath(), null, null);
        } else if (uri.getScheme() != null && uri.getScheme().equals(DEFAULT_SCHEME)) {
            String path = uri.getPath();
            if (uri.toString().startsWith("file:///")) {
                uri = new URI(DEFAULT_SCHEME, null, path, null, null);
            }
        }
        return uri;
    }

    private static DatasetIdentifier prepareHiveDatasetIdentifier(CatalogTable catalogTable, URI metastoreUri) {
        String qualifiedName = PathUtils.nameFromTableIdentifier(catalogTable.identifier());
        if (!qualifiedName.startsWith(DEFAULT_SEPARATOR)) {
            qualifiedName = String.format("/%s", qualifiedName);
        }
        return PathUtils.fromPath(new Path(PathUtils.enrichHiveMetastoreURIWithTableName(metastoreUri, qualifiedName)));
    }

    public static URI enrichHiveMetastoreURIWithTableName(URI metastoreUri, String qualifiedName) {
        return new URI("hive", null, metastoreUri.getHost(), metastoreUri.getPort(), qualifiedName, null, null);
    }

    private static Optional<SparkConf> loadSparkConf() {
        if (!sparkConf.isPresent() && SparkSession.getDefaultSession().isDefined()) {
            sparkConf = Optional.of(((SparkSession)SparkSession.getDefaultSession().get()).sparkContext().getConf());
        }
        return sparkConf;
    }

    private static Optional<URI> extractMetastoreUri(Optional<SparkConf> sparkConf) {
        if (!sparkConf.isPresent()) {
            return Optional.empty();
        }
        Optional<String> setting = SparkConfUtils.findSparkConfigKey(sparkConf.get(), StaticSQLConf.CATALOG_IMPLEMENTATION().key());
        if (!setting.isPresent() || !"hive".equals(setting.get())) {
            return Optional.empty();
        }
        return SparkConfUtils.getMetastoreUri(sparkConf.get());
    }

    private static String nameFromTableIdentifier(TableIdentifier identifier) {
        String name = identifier.database().isDefined() ? String.format("%s.%s", identifier.database().get(), identifier.table()) : identifier.table();
        return name;
    }
}

