/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class RemovePathPatternUtils {
    public static final String REMOVE_PATTERN_GROUP = "remove";
    public static final String SPARK_OPENLINEAGE_DATASET_REMOVE_PATH_PATTERN = "spark.openlineage.dataset.removePath.pattern";

    public static List<OpenLineage.OutputDataset> removeOutputsPathPattern(OpenLineageContext context, List<OpenLineage.OutputDataset> outputs) {
        return RemovePathPatternUtils.getPattern(context).map(pattern -> outputs.stream().map(dataset -> {
            String newName = RemovePathPatternUtils.removePath(pattern, dataset.getName());
            if (newName != dataset.getName()) {
                return context.getOpenLineage().newOutputDatasetBuilder().name(RemovePathPatternUtils.removePath(pattern, dataset.getName())).namespace(dataset.getNamespace()).facets(dataset.getFacets()).outputFacets(dataset.getOutputFacets()).build();
            }
            return dataset;
        }).collect(Collectors.toList())).orElse(outputs);
    }

    public static List<OpenLineage.InputDataset> removeInputsPathPattern(OpenLineageContext context, List<OpenLineage.InputDataset> outputs) {
        return RemovePathPatternUtils.getPattern(context).map(pattern -> outputs.stream().map(dataset -> {
            String newName = RemovePathPatternUtils.removePath(pattern, dataset.getName());
            if (newName != dataset.getName()) {
                return context.getOpenLineage().newInputDatasetBuilder().name(newName).namespace(dataset.getNamespace()).facets(dataset.getFacets()).inputFacets(dataset.getInputFacets()).build();
            }
            return dataset;
        }).collect(Collectors.toList())).orElse(outputs);
    }

    private static Optional<Pattern> getPattern(OpenLineageContext context) {
        return Optional.ofNullable(context.getSparkContext()).map(sparkContext -> sparkContext.conf()).filter(conf -> conf.contains(SPARK_OPENLINEAGE_DATASET_REMOVE_PATH_PATTERN)).map(conf -> conf.get(SPARK_OPENLINEAGE_DATASET_REMOVE_PATH_PATTERN)).map(pattern -> Pattern.compile(pattern));
    }

    private static String removePath(Pattern pattern, String name) {
        return Optional.ofNullable(pattern.matcher(name)).filter(matcher -> matcher.find()).filter(matcher -> {
            try {
                matcher.group(REMOVE_PATTERN_GROUP);
                return true;
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return false;
            }
        }).filter(matcher -> StringUtils.isNotEmpty((String)matcher.group(REMOVE_PATTERN_GROUP))).map(matcher -> name.substring(0, matcher.start(REMOVE_PATTERN_GROUP)) + name.substring(matcher.end(REMOVE_PATTERN_GROUP), name.length())).orElse(name);
    }
}

