/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.sql.OpenLineageSql;
import io.openlineage.sql.SqlMeta;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    public static <D extends OpenLineage.Dataset> List<D> getDatasets(DatasetFactory<D> datasetFactory, String sql, String dialect, String namespace) {
        return SqlUtils.getDatasets(datasetFactory, sql, dialect, namespace, null, null);
    }

    public static <D extends OpenLineage.Dataset> List<D> getDatasets(DatasetFactory<D> datasetFactory, String sql, String dialect, String namespace, String defaultDatabase, String defaultSchema) {
        Optional<SqlMeta> sqlMeta = OpenLineageSql.parse(Collections.singletonList(sql), dialect);
        return sqlMeta.map(meta -> meta.inTables().stream().map(dbtm -> datasetFactory.getDataset(new DatasetIdentifier(SqlUtils.getName(defaultDatabase, defaultSchema, dbtm.qualifiedName()), namespace), new OpenLineage.DatasetFacetsBuilder())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static String getName(String defaultDatabase, String defaultSchema, String parsedName) {
        String[] parts = parsedName.split("\\.");
        if (parts.length == 2) {
            return String.format("%s.%s.%s", defaultDatabase, parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return String.format("%s.%s.%s", defaultDatabase, defaultSchema, parts[0]);
        }
        return parsedName;
    }
}

