/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.vendor.snowflake.lifecycle;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.SqlUtils;
import io.openlineage.spark.api.DatasetFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeDataset {
    public static final String SNOWFLAKE_PREFIX = "snowflake://";
    private static final Logger logger = LoggerFactory.getLogger(SnowflakeDataset.class);

    public static <D extends OpenLineage.Dataset> List<D> getDatasets(DatasetFactory<D> factory, String sfFullURL, String sfDatabase, String sfSchema, Optional<String> dbtable, Optional<String> query, StructType schema) {
        String namespace = String.format("%s%s", SNOWFLAKE_PREFIX, sfFullURL.replace("https://", ""));
        if (dbtable.isPresent()) {
            String tableName = dbtable.get();
            String name = String.format("%s.%s.%s", sfDatabase, sfSchema, tableName);
            return Collections.singletonList(factory.getDataset(name, namespace, schema));
        }
        if (query.isPresent()) {
            return SqlUtils.getDatasets(factory, query.get(), "snowflake", namespace, sfDatabase, sfSchema);
        }
        logger.warn("Unable to discover Snowflake table property - neither \"dbtable\" nor \"query\" option present");
        return Collections.emptyList();
    }
}

