/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.vendor.snowflake.lifecycle;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.agent.vendor.snowflake.lifecycle.SnowflakeDataset;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.List;
import java.util.Optional;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeRelation;
import net.snowflake.spark.snowflake.TableName;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeRelationVisitor<D extends OpenLineage.Dataset>
extends QueryPlanVisitor<LogicalRelation, D> {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeRelationVisitor.class);
    private final DatasetFactory<D> factory;

    public SnowflakeRelationVisitor(OpenLineageContext context, DatasetFactory<D> factory) {
        super(context);
        this.factory = factory;
    }

    protected boolean isSnowflakeClass(LogicalPlan plan) {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass("net.snowflake.spark.snowflake.SnowflakeRelation");
            return plan instanceof LogicalRelation && c.isAssignableFrom(((LogicalRelation)plan).relation().getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return this.isSnowflakeClass(plan);
    }

    public List<D> apply(LogicalPlan x) {
        SnowflakeRelation relation = (SnowflakeRelation)((LogicalRelation)x).relation();
        Parameters.MergedParameters params = relation.params();
        String sfDatabase = params.sfDatabase();
        String sfSchema = params.sfSchema();
        String sfFullURL = params.sfFullURL();
        Optional<String> dbtable = ScalaConversionUtils.asJavaOptional(params.table()).map(TableName::toString);
        Optional<String> query = ScalaConversionUtils.asJavaOptional(params.query());
        return SnowflakeDataset.getDatasets(this.factory, sfFullURL, sfDatabase, sfSchema, dbtable, query, relation.schema());
    }
}

