/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.vendor.snowflake.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.agent.vendor.snowflake.SnowflakeVendor;
import io.openlineage.spark.agent.vendor.snowflake.lifecycle.SnowflakeDataset;
import io.openlineage.spark.api.AbstractQueryPlanDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.snowflake.spark.snowflake.DefaultSource;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.execution.datasources.SaveIntoDataSourceCommand;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.types.StructType;

public class SnowflakeSaveIntoDataSourceCommandDatasetBuilder
extends AbstractQueryPlanDatasetBuilder<SparkListenerEvent, SaveIntoDataSourceCommand, OpenLineage.OutputDataset> {
    public SnowflakeSaveIntoDataSourceCommandDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public List<OpenLineage.OutputDataset> apply(SaveIntoDataSourceCommand command) {
        if (SnowflakeSaveIntoDataSourceCommandDatasetBuilder.isSnowflakeSource(command.dataSource())) {
            Map options = ScalaConversionUtils.fromMap(command.options());
            Optional<String> dbtable = Optional.ofNullable(options.get("dbtable"));
            Optional<String> query = Optional.ofNullable(options.get("query"));
            String sfSchema = (String)options.get("sfschema");
            String sfUrl = (String)options.get("sfurl");
            String sfDatabase = (String)options.get("sfdatabase");
            return SnowflakeDataset.getDatasets(this.outputDataset(), sfUrl, sfDatabase, sfSchema, dbtable, query, this.getSchema(command));
        }
        return Collections.emptyList();
    }

    public static boolean isSnowflakeSource(CreatableRelationProvider provider) {
        return SnowflakeVendor.hasSnowflakeClasses() && provider instanceof DefaultSource;
    }

    private StructType getSchema(SaveIntoDataSourceCommand command) {
        StructType schema = command.schema();
        if ((schema == null || schema.fields() == null || schema.fields().length == 0) && command.query() != null && command.query().output() != null) {
            schema = PlanUtils.toStructType(ScalaConversionUtils.fromSeq(command.query().output()));
        }
        return schema;
    }
}

